/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ControllingAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ControllingAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Controlling Area (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ControllingArea</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingArea extends VdmEntity<ControllingArea>
{

    /**
     * Selector for all available fields of ControllingArea.
     *
     */
    public final static ControllingAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_ID</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea_ID" )
    @JsonProperty( "ControllingArea_ID" )
    @Nullable
    @ODataField( odataName = "ControllingArea_ID" )
    private String controllingArea_ID;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea_ID</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA_ID =
        new ControllingAreaField<String>("ControllingArea_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaText</b>
     * </p>
     *
     * @return Controlling Area (Description)
     */
    @SerializedName( "ControllingAreaText" )
    @JsonProperty( "ControllingAreaText" )
    @Nullable
    @ODataField( odataName = "ControllingAreaText" )
    private String controllingAreaText;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaText</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA_TEXT =
        new ControllingAreaField<String>("ControllingAreaText");

    @Nonnull
    @Override
    public Class<ControllingArea> getType()
    {
        return ControllingArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_ID</b>
     * </p>
     *
     * @param controllingArea_ID
     *            Controlling Area
     */
    public void setControllingArea_ID( @Nullable final String controllingArea_ID )
    {
        rememberChangedField("ControllingArea_ID", this.controllingArea_ID);
        this.controllingArea_ID = controllingArea_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaText</b>
     * </p>
     *
     * @param controllingAreaText
     *            Controlling Area (Description)
     */
    public void setControllingAreaText( @Nullable final String controllingAreaText )
    {
        rememberChangedField("ControllingAreaText", this.controllingAreaText);
        this.controllingAreaText = controllingAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ControllingArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea_ID", getControllingArea_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea_ID", getControllingArea_ID());
        values.put("ControllingAreaText", getControllingAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea_ID") ) {
                final Object value = values.remove("ControllingArea_ID");
                if( (value == null) || (!value.equals(getControllingArea_ID())) ) {
                    setControllingArea_ID(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaText") ) {
                final Object value = values.remove("ControllingAreaText");
                if( (value == null) || (!value.equals(getControllingAreaText())) ) {
                    setControllingAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ControllingAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ControllingAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
