/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ControllingObjectClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ControllingObjectClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Controlling Object Class (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ControllingObjectClass</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingObjectClass extends VdmEntity<ControllingObjectClass>
{

    /**
     * Selector for all available fields of ControllingObjectClass.
     *
     */
    public final static ControllingObjectClassSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass_ID</b>
     * </p>
     *
     * @return Controlling Object Class
     */
    @Key
    @SerializedName( "ControllingObjectClass_ID" )
    @JsonProperty( "ControllingObjectClass_ID" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClass_ID" )
    private String controllingObjectClass_ID;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClass_ID</b> field to query operations.
     *
     */
    public final static ControllingObjectClassField<String> CONTROLLING_OBJECT_CLASS_ID =
        new ControllingObjectClassField<String>("ControllingObjectClass_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClassText</b>
     * </p>
     *
     * @return Controlling Object Class (Description)
     */
    @SerializedName( "ControllingObjectClassText" )
    @JsonProperty( "ControllingObjectClassText" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClassText" )
    private String controllingObjectClassText;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClassText</b> field to query operations.
     *
     */
    public final static ControllingObjectClassField<String> CONTROLLING_OBJECT_CLASS_TEXT =
        new ControllingObjectClassField<String>("ControllingObjectClassText");

    @Nonnull
    @Override
    public Class<ControllingObjectClass> getType()
    {
        return ControllingObjectClass.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass_ID</b>
     * </p>
     *
     * @param controllingObjectClass_ID
     *            Controlling Object Class
     */
    public void setControllingObjectClass_ID( @Nullable final String controllingObjectClass_ID )
    {
        rememberChangedField("ControllingObjectClass_ID", this.controllingObjectClass_ID);
        this.controllingObjectClass_ID = controllingObjectClass_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClassText</b>
     * </p>
     *
     * @param controllingObjectClassText
     *            Controlling Object Class (Description)
     */
    public void setControllingObjectClassText( @Nullable final String controllingObjectClassText )
    {
        rememberChangedField("ControllingObjectClassText", this.controllingObjectClassText);
        this.controllingObjectClassText = controllingObjectClassText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ControllingObjectClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingObjectClass_ID", getControllingObjectClass_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingObjectClass_ID", getControllingObjectClass_ID());
        values.put("ControllingObjectClassText", getControllingObjectClassText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingObjectClass_ID") ) {
                final Object value = values.remove("ControllingObjectClass_ID");
                if( (value == null) || (!value.equals(getControllingObjectClass_ID())) ) {
                    setControllingObjectClass_ID(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectClassText") ) {
                final Object value = values.remove("ControllingObjectClassText");
                if( (value == null) || (!value.equals(getControllingObjectClassText())) ) {
                    setControllingObjectClassText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ControllingObjectClassField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ControllingObjectClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingObjectClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingObjectClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
