/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ControllingObjectDebitField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ControllingObjectDebitSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Controlling Object Debit Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ControllingObjectDebitType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingObjectDebit extends VdmEntity<ControllingObjectDebit>
{

    /**
     * Selector for all available fields of ControllingObjectDebit.
     *
     */
    public final static ControllingObjectDebitSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType_ID</b>
     * </p>
     *
     * @return Controlling Object Debit Type
     */
    @Key
    @SerializedName( "ControllingObjectDebitType_ID" )
    @JsonProperty( "ControllingObjectDebitType_ID" )
    @Nullable
    @ODataField( odataName = "ControllingObjectDebitType_ID" )
    private String controllingObjectDebitType_ID;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectDebitType_ID</b> field to query operations.
     *
     */
    public final static ControllingObjectDebitField<String> CONTROLLING_OBJECT_DEBIT_TYPE_ID =
        new ControllingObjectDebitField<String>("ControllingObjectDebitType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitTypeText</b>
     * </p>
     *
     * @return Controlling Object Debit Type (Description)
     */
    @SerializedName( "ControllingObjectDebitTypeText" )
    @JsonProperty( "ControllingObjectDebitTypeText" )
    @Nullable
    @ODataField( odataName = "ControllingObjectDebitTypeText" )
    private String controllingObjectDebitTypeText;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectDebitTypeText</b> field to query operations.
     *
     */
    public final static ControllingObjectDebitField<String> CONTROLLING_OBJECT_DEBIT_TYPE_TEXT =
        new ControllingObjectDebitField<String>("ControllingObjectDebitTypeText");

    @Nonnull
    @Override
    public Class<ControllingObjectDebit> getType()
    {
        return ControllingObjectDebit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType_ID</b>
     * </p>
     *
     * @param controllingObjectDebitType_ID
     *            Controlling Object Debit Type
     */
    public void setControllingObjectDebitType_ID( @Nullable final String controllingObjectDebitType_ID )
    {
        rememberChangedField("ControllingObjectDebitType_ID", this.controllingObjectDebitType_ID);
        this.controllingObjectDebitType_ID = controllingObjectDebitType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitTypeText</b>
     * </p>
     *
     * @param controllingObjectDebitTypeText
     *            Controlling Object Debit Type (Description)
     */
    public void setControllingObjectDebitTypeText( @Nullable final String controllingObjectDebitTypeText )
    {
        rememberChangedField("ControllingObjectDebitTypeText", this.controllingObjectDebitTypeText);
        this.controllingObjectDebitTypeText = controllingObjectDebitTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ControllingObjectDebitType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingObjectDebitType_ID", getControllingObjectDebitType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingObjectDebitType_ID", getControllingObjectDebitType_ID());
        values.put("ControllingObjectDebitTypeText", getControllingObjectDebitTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingObjectDebitType_ID") ) {
                final Object value = values.remove("ControllingObjectDebitType_ID");
                if( (value == null) || (!value.equals(getControllingObjectDebitType_ID())) ) {
                    setControllingObjectDebitType_ID(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectDebitTypeText") ) {
                final Object value = values.remove("ControllingObjectDebitTypeText");
                if( (value == null) || (!value.equals(getControllingObjectDebitTypeText())) ) {
                    setControllingObjectDebitTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ControllingObjectDebitField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ControllingObjectDebitField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingObjectDebitField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingObjectDebitField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
