/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CorporateGroupAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CorporateGroupAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Group Account Number (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CorporateGroupAccount</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CorporateGroupAccount extends VdmEntity<CorporateGroupAccount>
{

    /**
     * Selector for all available fields of CorporateGroupAccount.
     *
     */
    public final static CorporateGroupAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount_ID</b>
     * </p>
     *
     * @return Group Account Number
     */
    @Key
    @SerializedName( "CorporateGroupAccount_ID" )
    @JsonProperty( "CorporateGroupAccount_ID" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount_ID" )
    private String corporateGroupAccount_ID;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount_ID</b> field to query operations.
     *
     */
    public final static CorporateGroupAccountField<String> CORPORATE_GROUP_ACCOUNT_ID =
        new CorporateGroupAccountField<String>("CorporateGroupAccount_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccountText</b>
     * </p>
     *
     * @return Group Account Number (Description)
     */
    @SerializedName( "CorporateGroupAccountText" )
    @JsonProperty( "CorporateGroupAccountText" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccountText" )
    private String corporateGroupAccountText;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccountText</b> field to query operations.
     *
     */
    public final static CorporateGroupAccountField<String> CORPORATE_GROUP_ACCOUNT_TEXT =
        new CorporateGroupAccountField<String>("CorporateGroupAccountText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @return Group Account Number (Group Chart of Accts)
     */
    @Key
    @SerializedName( "CorporateGroupChartOfAccounts" )
    @JsonProperty( "CorporateGroupChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CorporateGroupChartOfAccounts" )
    private String corporateGroupChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupChartOfAccounts</b> field to query operations.
     *
     */
    public final static CorporateGroupAccountField<String> CORPORATE_GROUP_CHART_OF_ACCOUNTS =
        new CorporateGroupAccountField<String>("CorporateGroupChartOfAccounts");

    @Nonnull
    @Override
    public Class<CorporateGroupAccount> getType()
    {
        return CorporateGroupAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount_ID</b>
     * </p>
     *
     * @param corporateGroupAccount_ID
     *            Group Account Number
     */
    public void setCorporateGroupAccount_ID( @Nullable final String corporateGroupAccount_ID )
    {
        rememberChangedField("CorporateGroupAccount_ID", this.corporateGroupAccount_ID);
        this.corporateGroupAccount_ID = corporateGroupAccount_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccountText</b>
     * </p>
     *
     * @param corporateGroupAccountText
     *            Group Account Number (Description)
     */
    public void setCorporateGroupAccountText( @Nullable final String corporateGroupAccountText )
    {
        rememberChangedField("CorporateGroupAccountText", this.corporateGroupAccountText);
        this.corporateGroupAccountText = corporateGroupAccountText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @param corporateGroupChartOfAccounts
     *            Group Account Number (Group Chart of Accts)
     */
    public void setCorporateGroupChartOfAccounts( @Nullable final String corporateGroupChartOfAccounts )
    {
        rememberChangedField("CorporateGroupChartOfAccounts", this.corporateGroupChartOfAccounts);
        this.corporateGroupChartOfAccounts = corporateGroupChartOfAccounts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CorporateGroupAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CorporateGroupAccount_ID", getCorporateGroupAccount_ID());
        result.put("CorporateGroupChartOfAccounts", getCorporateGroupChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CorporateGroupAccount_ID", getCorporateGroupAccount_ID());
        values.put("CorporateGroupAccountText", getCorporateGroupAccountText());
        values.put("CorporateGroupChartOfAccounts", getCorporateGroupChartOfAccounts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CorporateGroupAccount_ID") ) {
                final Object value = values.remove("CorporateGroupAccount_ID");
                if( (value == null) || (!value.equals(getCorporateGroupAccount_ID())) ) {
                    setCorporateGroupAccount_ID(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccountText") ) {
                final Object value = values.remove("CorporateGroupAccountText");
                if( (value == null) || (!value.equals(getCorporateGroupAccountText())) ) {
                    setCorporateGroupAccountText(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupChartOfAccounts") ) {
                final Object value = values.remove("CorporateGroupChartOfAccounts");
                if( (value == null) || (!value.equals(getCorporateGroupChartOfAccounts())) ) {
                    setCorporateGroupChartOfAccounts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CorporateGroupAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CorporateGroupAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CorporateGroupAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CorporateGroupAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
