/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CorporateGroupAccountSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount CorporateGroupAccount}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class CorporateGroupAccountByKeyFluentHelper
    extends
    FluentHelperByKey<CorporateGroupAccountByKeyFluentHelper, CorporateGroupAccount, CorporateGroupAccountSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount
     * CorporateGroupAccount} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CorporateGroupAccount}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CorporateGroupAccount}
     * @param corporateGroupChartOfAccounts
     *            Group Account Number (Group Chart of Accts)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param corporateGroupAccount_ID
     *            Group Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CorporateGroupAccountByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String corporateGroupAccount_ID,
        final String corporateGroupChartOfAccounts )
    {
        super(servicePath, entityCollection);
        this.key.put("CorporateGroupAccount_ID", corporateGroupAccount_ID);
        this.key.put("CorporateGroupChartOfAccounts", corporateGroupChartOfAccounts);
    }

    @Override
    @Nonnull
    protected Class<CorporateGroupAccount> getEntityClass()
    {
        return CorporateGroupAccount.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
