/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CorporateGroupChartOfAccountsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CorporateGroupChartOfAccountsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Group Chart of Accts (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CorporateGroupChartOfAccounts extends VdmEntity<CorporateGroupChartOfAccounts>
{

    /**
     * Selector for all available fields of CorporateGroupChartOfAccounts.
     *
     */
    public final static CorporateGroupChartOfAccountsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts_ID</b>
     * </p>
     *
     * @return Group Chart of Accts
     */
    @Key
    @SerializedName( "CorporateGroupChartOfAccounts_ID" )
    @JsonProperty( "CorporateGroupChartOfAccounts_ID" )
    @Nullable
    @ODataField( odataName = "CorporateGroupChartOfAccounts_ID" )
    private String corporateGroupChartOfAccounts_ID;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupChartOfAccounts_ID</b> field to query operations.
     *
     */
    public final static CorporateGroupChartOfAccountsField<String> CORPORATE_GROUP_CHART_OF_ACCOUNTS_ID =
        new CorporateGroupChartOfAccountsField<String>("CorporateGroupChartOfAccounts_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccountsText</b>
     * </p>
     *
     * @return Group Chart of Accts (Description)
     */
    @SerializedName( "CorporateGroupChartOfAccountsText" )
    @JsonProperty( "CorporateGroupChartOfAccountsText" )
    @Nullable
    @ODataField( odataName = "CorporateGroupChartOfAccountsText" )
    private String corporateGroupChartOfAccountsText;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupChartOfAccountsText</b> field to query
     * operations.
     *
     */
    public final static CorporateGroupChartOfAccountsField<String> CORPORATE_GROUP_CHART_OF_ACCOUNTS_TEXT =
        new CorporateGroupChartOfAccountsField<String>("CorporateGroupChartOfAccountsText");

    @Nonnull
    @Override
    public Class<CorporateGroupChartOfAccounts> getType()
    {
        return CorporateGroupChartOfAccounts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts_ID</b>
     * </p>
     *
     * @param corporateGroupChartOfAccounts_ID
     *            Group Chart of Accts
     */
    public void setCorporateGroupChartOfAccounts_ID( @Nullable final String corporateGroupChartOfAccounts_ID )
    {
        rememberChangedField("CorporateGroupChartOfAccounts_ID", this.corporateGroupChartOfAccounts_ID);
        this.corporateGroupChartOfAccounts_ID = corporateGroupChartOfAccounts_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccountsText</b>
     * </p>
     *
     * @param corporateGroupChartOfAccountsText
     *            Group Chart of Accts (Description)
     */
    public void setCorporateGroupChartOfAccountsText( @Nullable final String corporateGroupChartOfAccountsText )
    {
        rememberChangedField("CorporateGroupChartOfAccountsText", this.corporateGroupChartOfAccountsText);
        this.corporateGroupChartOfAccountsText = corporateGroupChartOfAccountsText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CorporateGroupChartOfAccounts";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CorporateGroupChartOfAccounts_ID", getCorporateGroupChartOfAccounts_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CorporateGroupChartOfAccounts_ID", getCorporateGroupChartOfAccounts_ID());
        values.put("CorporateGroupChartOfAccountsText", getCorporateGroupChartOfAccountsText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CorporateGroupChartOfAccounts_ID") ) {
                final Object value = values.remove("CorporateGroupChartOfAccounts_ID");
                if( (value == null) || (!value.equals(getCorporateGroupChartOfAccounts_ID())) ) {
                    setCorporateGroupChartOfAccounts_ID(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupChartOfAccountsText") ) {
                final Object value = values.remove("CorporateGroupChartOfAccountsText");
                if( (value == null) || (!value.equals(getCorporateGroupChartOfAccountsText())) ) {
                    setCorporateGroupChartOfAccountsText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CorporateGroupChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CorporateGroupChartOfAccountsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CorporateGroupChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CorporateGroupChartOfAccountsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
