/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CostCenterSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter
 * CostCenter} entity using key fields. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class CostCenterByKeyFluentHelper
    extends
    FluentHelperByKey<CostCenterByKeyFluentHelper, CostCenter, CostCenterSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter CostCenter} entity with the
     * provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CostCenter}
     * @param costCenter_ID
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CostCenter}
     * @param controllingArea
     *            Cost Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public CostCenterByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String costCenter_ID,
        final String controllingArea )
    {
        super(servicePath, entityCollection);
        this.key.put("CostCenter_ID", costCenter_ID);
        this.key.put("ControllingArea", controllingArea);
    }

    @Override
    @Nonnull
    protected Class<CostCenter> getEntityClass()
    {
        return CostCenter.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
