/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CountryChartOfAccountsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CountryChartOfAccountsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Alternative Chart of Accounts (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CountryChartOfAccounts</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CountryChartOfAccounts extends VdmEntity<CountryChartOfAccounts>
{

    /**
     * Selector for all available fields of CountryChartOfAccounts.
     *
     */
    public final static CountryChartOfAccountsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts_ID</b>
     * </p>
     *
     * @return Alternative Chart of Accounts
     */
    @Key
    @SerializedName( "CountryChartOfAccounts_ID" )
    @JsonProperty( "CountryChartOfAccounts_ID" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccounts_ID" )
    private String countryChartOfAccounts_ID;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccounts_ID</b> field to query operations.
     *
     */
    public final static CountryChartOfAccountsField<String> COUNTRY_CHART_OF_ACCOUNTS_ID =
        new CountryChartOfAccountsField<String>("CountryChartOfAccounts_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccountsText</b>
     * </p>
     *
     * @return Alternative Chart of Accounts (Description)
     */
    @SerializedName( "CountryChartOfAccountsText" )
    @JsonProperty( "CountryChartOfAccountsText" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccountsText" )
    private String countryChartOfAccountsText;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccountsText</b> field to query operations.
     *
     */
    public final static CountryChartOfAccountsField<String> COUNTRY_CHART_OF_ACCOUNTS_TEXT =
        new CountryChartOfAccountsField<String>("CountryChartOfAccountsText");

    @Nonnull
    @Override
    public Class<CountryChartOfAccounts> getType()
    {
        return CountryChartOfAccounts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts_ID</b>
     * </p>
     *
     * @param countryChartOfAccounts_ID
     *            Alternative Chart of Accounts
     */
    public void setCountryChartOfAccounts_ID( @Nullable final String countryChartOfAccounts_ID )
    {
        rememberChangedField("CountryChartOfAccounts_ID", this.countryChartOfAccounts_ID);
        this.countryChartOfAccounts_ID = countryChartOfAccounts_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccountsText</b>
     * </p>
     *
     * @param countryChartOfAccountsText
     *            Alternative Chart of Accounts (Description)
     */
    public void setCountryChartOfAccountsText( @Nullable final String countryChartOfAccountsText )
    {
        rememberChangedField("CountryChartOfAccountsText", this.countryChartOfAccountsText);
        this.countryChartOfAccountsText = countryChartOfAccountsText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CountryChartOfAccounts";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CountryChartOfAccounts_ID", getCountryChartOfAccounts_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CountryChartOfAccounts_ID", getCountryChartOfAccounts_ID());
        values.put("CountryChartOfAccountsText", getCountryChartOfAccountsText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CountryChartOfAccounts_ID") ) {
                final Object value = values.remove("CountryChartOfAccounts_ID");
                if( (value == null) || (!value.equals(getCountryChartOfAccounts_ID())) ) {
                    setCountryChartOfAccounts_ID(((String) value));
                }
            }
            if( values.containsKey("CountryChartOfAccountsText") ) {
                final Object value = values.remove("CountryChartOfAccountsText");
                if( (value == null) || (!value.equals(getCountryChartOfAccountsText())) ) {
                    setCountryChartOfAccountsText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CountryChartOfAccountsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CountryChartOfAccountsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CountryChartOfAccountsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CountryChartOfAccountsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
