/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CustomerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CustomerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Customer</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Customer extends VdmEntity<Customer>
{

    /**
     * Selector for all available fields of Customer.
     *
     */
    public final static CustomerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer_ID</b>
     * </p>
     *
     * @return Customer
     */
    @Key
    @SerializedName( "Customer_ID" )
    @JsonProperty( "Customer_ID" )
    @Nullable
    @ODataField( odataName = "Customer_ID" )
    private String customer_ID;
    /**
     * Use with available fluent helpers to apply the <b>Customer_ID</b> field to query operations.
     *
     */
    public final static CustomerField<String> CUSTOMER_ID = new CustomerField<String>("Customer_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerText</b>
     * </p>
     *
     * @return Customer (Description)
     */
    @SerializedName( "CustomerText" )
    @JsonProperty( "CustomerText" )
    @Nullable
    @ODataField( odataName = "CustomerText" )
    private String customerText;
    /**
     * Use with available fluent helpers to apply the <b>CustomerText</b> field to query operations.
     *
     */
    public final static CustomerField<String> CUSTOMER_TEXT = new CustomerField<String>("CustomerText");

    @Nonnull
    @Override
    public Class<Customer> getType()
    {
        return Customer.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer_ID</b>
     * </p>
     *
     * @param customer_ID
     *            Customer
     */
    public void setCustomer_ID( @Nullable final String customer_ID )
    {
        rememberChangedField("Customer_ID", this.customer_ID);
        this.customer_ID = customer_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerText</b>
     * </p>
     *
     * @param customerText
     *            Customer (Description)
     */
    public void setCustomerText( @Nullable final String customerText )
    {
        rememberChangedField("CustomerText", this.customerText);
        this.customerText = customerText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Customer";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer_ID", getCustomer_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer_ID", getCustomer_ID());
        values.put("CustomerText", getCustomerText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer_ID") ) {
                final Object value = values.remove("Customer_ID");
                if( (value == null) || (!value.equals(getCustomer_ID())) ) {
                    setCustomer_ID(((String) value));
                }
            }
            if( values.containsKey("CustomerText") ) {
                final Object value = values.remove("CustomerText");
                if( (value == null) || (!value.equals(getCustomerText())) ) {
                    setCustomerText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
