/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CustomerGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.CustomerGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Group (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustomerGroup</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerGroup extends VdmEntity<CustomerGroup>
{

    /**
     * Selector for all available fields of CustomerGroup.
     *
     */
    public final static CustomerGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup_ID</b>
     * </p>
     *
     * @return Customer Group
     */
    @Key
    @SerializedName( "CustomerGroup_ID" )
    @JsonProperty( "CustomerGroup_ID" )
    @Nullable
    @ODataField( odataName = "CustomerGroup_ID" )
    private String customerGroup_ID;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup_ID</b> field to query operations.
     *
     */
    public final static CustomerGroupField<String> CUSTOMER_GROUP_ID =
        new CustomerGroupField<String>("CustomerGroup_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupText</b>
     * </p>
     *
     * @return Customer Group (Description)
     */
    @SerializedName( "CustomerGroupText" )
    @JsonProperty( "CustomerGroupText" )
    @Nullable
    @ODataField( odataName = "CustomerGroupText" )
    private String customerGroupText;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroupText</b> field to query operations.
     *
     */
    public final static CustomerGroupField<String> CUSTOMER_GROUP_TEXT =
        new CustomerGroupField<String>("CustomerGroupText");

    @Nonnull
    @Override
    public Class<CustomerGroup> getType()
    {
        return CustomerGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup_ID</b>
     * </p>
     *
     * @param customerGroup_ID
     *            Customer Group
     */
    public void setCustomerGroup_ID( @Nullable final String customerGroup_ID )
    {
        rememberChangedField("CustomerGroup_ID", this.customerGroup_ID);
        this.customerGroup_ID = customerGroup_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupText</b>
     * </p>
     *
     * @param customerGroupText
     *            Customer Group (Description)
     */
    public void setCustomerGroupText( @Nullable final String customerGroupText )
    {
        rememberChangedField("CustomerGroupText", this.customerGroupText);
        this.customerGroupText = customerGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CustomerGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerGroup_ID", getCustomerGroup_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerGroup_ID", getCustomerGroup_ID());
        values.put("CustomerGroupText", getCustomerGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerGroup_ID") ) {
                final Object value = values.remove("CustomerGroup_ID");
                if( (value == null) || (!value.equals(getCustomerGroup_ID())) ) {
                    setCustomerGroup_ID(((String) value));
                }
            }
            if( values.containsKey("CustomerGroupText") ) {
                final Object value = values.remove("CustomerGroupText");
                if( (value == null) || (!value.equals(getCustomerGroupText())) ) {
                    setCustomerGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustomerGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
