/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.DebitCreditCodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.DebitCreditCodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Debit/Credit Code (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DebitCreditCode</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DebitCreditCode extends VdmEntity<DebitCreditCode>
{

    /**
     * Selector for all available fields of DebitCreditCode.
     *
     */
    public final static DebitCreditCodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode_ID</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @Key
    @SerializedName( "DebitCreditCode_ID" )
    @JsonProperty( "DebitCreditCode_ID" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode_ID" )
    private String debitCreditCode_ID;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode_ID</b> field to query operations.
     *
     */
    public final static DebitCreditCodeField<String> DEBIT_CREDIT_CODE_ID =
        new DebitCreditCodeField<String>("DebitCreditCode_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCodeText</b>
     * </p>
     *
     * @return Debit/Credit Code (Description)
     */
    @SerializedName( "DebitCreditCodeText" )
    @JsonProperty( "DebitCreditCodeText" )
    @Nullable
    @ODataField( odataName = "DebitCreditCodeText" )
    private String debitCreditCodeText;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCodeText</b> field to query operations.
     *
     */
    public final static DebitCreditCodeField<String> DEBIT_CREDIT_CODE_TEXT =
        new DebitCreditCodeField<String>("DebitCreditCodeText");

    @Nonnull
    @Override
    public Class<DebitCreditCode> getType()
    {
        return DebitCreditCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode_ID</b>
     * </p>
     *
     * @param debitCreditCode_ID
     *            Debit/Credit Code
     */
    public void setDebitCreditCode_ID( @Nullable final String debitCreditCode_ID )
    {
        rememberChangedField("DebitCreditCode_ID", this.debitCreditCode_ID);
        this.debitCreditCode_ID = debitCreditCode_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCodeText</b>
     * </p>
     *
     * @param debitCreditCodeText
     *            Debit/Credit Code (Description)
     */
    public void setDebitCreditCodeText( @Nullable final String debitCreditCodeText )
    {
        rememberChangedField("DebitCreditCodeText", this.debitCreditCodeText);
        this.debitCreditCodeText = debitCreditCodeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "DebitCreditCode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DebitCreditCode_ID", getDebitCreditCode_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DebitCreditCode_ID", getDebitCreditCode_ID());
        values.put("DebitCreditCodeText", getDebitCreditCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DebitCreditCode_ID") ) {
                final Object value = values.remove("DebitCreditCode_ID");
                if( (value == null) || (!value.equals(getDebitCreditCode_ID())) ) {
                    setDebitCreditCode_ID(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCodeText") ) {
                final Object value = values.remove("DebitCreditCodeText");
                if( (value == null) || (!value.equals(getDebitCreditCodeText())) ) {
                    setDebitCreditCodeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DebitCreditCodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DebitCreditCodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DebitCreditCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DebitCreditCodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
