/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.EliminationProfitCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.EliminationProfitCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Elimination Profit Center (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EliminationProfitCenter</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EliminationProfitCenter extends VdmEntity<EliminationProfitCenter>
{

    /**
     * Selector for all available fields of EliminationProfitCenter.
     *
     */
    public final static EliminationProfitCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter_ID</b>
     * </p>
     *
     * @return Elimination Profit Center
     */
    @Key
    @SerializedName( "EliminationProfitCenter_ID" )
    @JsonProperty( "EliminationProfitCenter_ID" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenter_ID" )
    private String eliminationProfitCenter_ID;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenter_ID</b> field to query operations.
     *
     */
    public final static EliminationProfitCenterField<String> ELIMINATION_PROFIT_CENTER_ID =
        new EliminationProfitCenterField<String>("EliminationProfitCenter_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenterText</b>
     * </p>
     *
     * @return Elimination Profit Center (Description)
     */
    @SerializedName( "EliminationProfitCenterText" )
    @JsonProperty( "EliminationProfitCenterText" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenterText" )
    private String eliminationProfitCenterText;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenterText</b> field to query operations.
     *
     */
    public final static EliminationProfitCenterField<String> ELIMINATION_PROFIT_CENTER_TEXT =
        new EliminationProfitCenterField<String>("EliminationProfitCenterText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Elimination Profit Center (Controlling Area)
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static EliminationProfitCenterField<String> CONTROLLING_AREA =
        new EliminationProfitCenterField<String>("ControllingArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area (Description) (Parent Description)
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static EliminationProfitCenterField<String> CONTROLLING_AREA_NAME =
        new EliminationProfitCenterField<String>("ControllingAreaName");

    @Nonnull
    @Override
    public Class<EliminationProfitCenter> getType()
    {
        return EliminationProfitCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter_ID</b>
     * </p>
     *
     * @param eliminationProfitCenter_ID
     *            Elimination Profit Center
     */
    public void setEliminationProfitCenter_ID( @Nullable final String eliminationProfitCenter_ID )
    {
        rememberChangedField("EliminationProfitCenter_ID", this.eliminationProfitCenter_ID);
        this.eliminationProfitCenter_ID = eliminationProfitCenter_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenterText</b>
     * </p>
     *
     * @param eliminationProfitCenterText
     *            Elimination Profit Center (Description)
     */
    public void setEliminationProfitCenterText( @Nullable final String eliminationProfitCenterText )
    {
        rememberChangedField("EliminationProfitCenterText", this.eliminationProfitCenterText);
        this.eliminationProfitCenterText = eliminationProfitCenterText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Elimination Profit Center (Controlling Area)
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area (Description) (Parent Description)
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EliminationProfitCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EliminationProfitCenter_ID", getEliminationProfitCenter_ID());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EliminationProfitCenter_ID", getEliminationProfitCenter_ID());
        values.put("EliminationProfitCenterText", getEliminationProfitCenterText());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EliminationProfitCenter_ID") ) {
                final Object value = values.remove("EliminationProfitCenter_ID");
                if( (value == null) || (!value.equals(getEliminationProfitCenter_ID())) ) {
                    setEliminationProfitCenter_ID(((String) value));
                }
            }
            if( values.containsKey("EliminationProfitCenterText") ) {
                final Object value = values.remove("EliminationProfitCenterText");
                if( (value == null) || (!value.equals(getEliminationProfitCenterText())) ) {
                    setEliminationProfitCenterText(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EliminationProfitCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EliminationProfitCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EliminationProfitCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EliminationProfitCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
