/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.EliminationProfitCenterSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
 * EliminationProfitCenter} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class EliminationProfitCenterByKeyFluentHelper
    extends
    FluentHelperByKey<EliminationProfitCenterByKeyFluentHelper, EliminationProfitCenter, EliminationProfitCenterSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
     * EliminationProfitCenter} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EliminationProfitCenter}
     * @param eliminationProfitCenter_ID
     *            Elimination Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code EliminationProfitCenter}
     * @param controllingArea
     *            Elimination Profit Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public EliminationProfitCenterByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String eliminationProfitCenter_ID,
        final String controllingArea )
    {
        super(servicePath, entityCollection);
        this.key.put("EliminationProfitCenter_ID", eliminationProfitCenter_ID);
        this.key.put("ControllingArea", controllingArea);
    }

    @Override
    @Nonnull
    protected Class<EliminationProfitCenter> getEntityClass()
    {
        return EliminationProfitCenter.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
