/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FinancialAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FinancialAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Account Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialAccount extends VdmEntity<FinancialAccount>
{

    /**
     * Selector for all available fields of FinancialAccount.
     *
     */
    public final static FinancialAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType_ID</b>
     * </p>
     *
     * @return Account Type
     */
    @Key
    @SerializedName( "FinancialAccountType_ID" )
    @JsonProperty( "FinancialAccountType_ID" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType_ID" )
    private String financialAccountType_ID;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType_ID</b> field to query operations.
     *
     */
    public final static FinancialAccountField<String> FINANCIAL_ACCOUNT_TYPE_ID =
        new FinancialAccountField<String>("FinancialAccountType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeText</b>
     * </p>
     *
     * @return Account Type (Description)
     */
    @SerializedName( "FinancialAccountTypeText" )
    @JsonProperty( "FinancialAccountTypeText" )
    @Nullable
    @ODataField( odataName = "FinancialAccountTypeText" )
    private String financialAccountTypeText;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountTypeText</b> field to query operations.
     *
     */
    public final static FinancialAccountField<String> FINANCIAL_ACCOUNT_TYPE_TEXT =
        new FinancialAccountField<String>("FinancialAccountTypeText");

    @Nonnull
    @Override
    public Class<FinancialAccount> getType()
    {
        return FinancialAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType_ID</b>
     * </p>
     *
     * @param financialAccountType_ID
     *            Account Type
     */
    public void setFinancialAccountType_ID( @Nullable final String financialAccountType_ID )
    {
        rememberChangedField("FinancialAccountType_ID", this.financialAccountType_ID);
        this.financialAccountType_ID = financialAccountType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeText</b>
     * </p>
     *
     * @param financialAccountTypeText
     *            Account Type (Description)
     */
    public void setFinancialAccountTypeText( @Nullable final String financialAccountTypeText )
    {
        rememberChangedField("FinancialAccountTypeText", this.financialAccountTypeText);
        this.financialAccountTypeText = financialAccountTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialAccountType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FinancialAccountType_ID", getFinancialAccountType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FinancialAccountType_ID", getFinancialAccountType_ID());
        values.put("FinancialAccountTypeText", getFinancialAccountTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FinancialAccountType_ID") ) {
                final Object value = values.remove("FinancialAccountType_ID");
                if( (value == null) || (!value.equals(getFinancialAccountType_ID())) ) {
                    setFinancialAccountType_ID(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountTypeText") ) {
                final Object value = values.remove("FinancialAccountTypeText");
                if( (value == null) || (!value.equals(getFinancialAccountTypeText())) ) {
                    setFinancialAccountTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinancialAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinancialAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
