/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FinancialManagementAreaSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
 * FinancialManagementArea} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class FinancialManagementAreaByKeyFluentHelper
    extends
    FluentHelperByKey<FinancialManagementAreaByKeyFluentHelper, FinancialManagementArea, FinancialManagementAreaSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
     * FinancialManagementArea} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FinancialManagementArea}
     * @param financialManagementArea
     *            FM Area
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FinancialManagementArea}
     */
    public FinancialManagementAreaByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String financialManagementArea )
    {
        super(servicePath, entityCollection);
        this.key.put("FinancialManagementArea", financialManagementArea);
    }

    @Override
    @Nonnull
    protected Class<FinancialManagementArea> getEntityClass()
    {
        return FinancialManagementArea.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
