/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FinancialTransactionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FinancialTransactionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Financial Transaction Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialTransactionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialTransaction extends VdmEntity<FinancialTransaction>
{

    /**
     * Selector for all available fields of FinancialTransaction.
     *
     */
    public final static FinancialTransactionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_ID</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @Key
    @SerializedName( "FinancialTransactionType_ID" )
    @JsonProperty( "FinancialTransactionType_ID" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType_ID" )
    private String financialTransactionType_ID;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType_ID</b> field to query operations.
     *
     */
    public final static FinancialTransactionField<String> FINANCIAL_TRANSACTION_TYPE_ID =
        new FinancialTransactionField<String>("FinancialTransactionType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionTypeText</b>
     * </p>
     *
     * @return Financial Transaction Type (Description)
     */
    @SerializedName( "FinancialTransactionTypeText" )
    @JsonProperty( "FinancialTransactionTypeText" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionTypeText" )
    private String financialTransactionTypeText;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionTypeText</b> field to query operations.
     *
     */
    public final static FinancialTransactionField<String> FINANCIAL_TRANSACTION_TYPE_TEXT =
        new FinancialTransactionField<String>("FinancialTransactionTypeText");

    @Nonnull
    @Override
    public Class<FinancialTransaction> getType()
    {
        return FinancialTransaction.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType_ID</b>
     * </p>
     *
     * @param financialTransactionType_ID
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType_ID( @Nullable final String financialTransactionType_ID )
    {
        rememberChangedField("FinancialTransactionType_ID", this.financialTransactionType_ID);
        this.financialTransactionType_ID = financialTransactionType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionTypeText</b>
     * </p>
     *
     * @param financialTransactionTypeText
     *            Financial Transaction Type (Description)
     */
    public void setFinancialTransactionTypeText( @Nullable final String financialTransactionTypeText )
    {
        rememberChangedField("FinancialTransactionTypeText", this.financialTransactionTypeText);
        this.financialTransactionTypeText = financialTransactionTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialTransactionType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FinancialTransactionType_ID", getFinancialTransactionType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FinancialTransactionType_ID", getFinancialTransactionType_ID());
        values.put("FinancialTransactionTypeText", getFinancialTransactionTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FinancialTransactionType_ID") ) {
                final Object value = values.remove("FinancialTransactionType_ID");
                if( (value == null) || (!value.equals(getFinancialTransactionType_ID())) ) {
                    setFinancialTransactionType_ID(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionTypeText") ) {
                final Object value = values.remove("FinancialTransactionTypeText");
                if( (value == null) || (!value.equals(getFinancialTransactionTypeText())) ) {
                    setFinancialTransactionTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinancialTransactionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinancialTransactionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialTransactionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialTransactionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
