/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FinancialTransactionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction FinancialTransaction}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class FinancialTransactionByKeyFluentHelper
    extends
    FluentHelperByKey<FinancialTransactionByKeyFluentHelper, FinancialTransaction, FinancialTransactionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction
     * FinancialTransaction} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FinancialTransaction}
     * @param servicePath
     *            Service path to be used to fetch a single {@code FinancialTransaction}
     * @param financialTransactionType_ID
     *            Financial Transaction Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public FinancialTransactionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String financialTransactionType_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("FinancialTransactionType_ID", financialTransactionType_ID);
    }

    @Override
    @Nonnull
    protected Class<FinancialTransaction> getEntityClass()
    {
        return FinancialTransaction.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
