/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FiscalYearSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYear
 * FiscalYear} entity using key fields. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class FiscalYearByKeyFluentHelper
    extends
    FluentHelperByKey<FiscalYearByKeyFluentHelper, FiscalYear, FiscalYearSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYear FiscalYear} entity with the
     * provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param companyCode
     *            Fiscal Year (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FiscalYear}
     * @param servicePath
     *            Service path to be used to fetch a single {@code FiscalYear}
     * @param fiscalYear_ID
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public FiscalYearByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String fiscalYear_ID,
        final String companyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("FiscalYear_ID", fiscalYear_ID);
        this.key.put("CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    protected Class<FiscalYear> getEntityClass()
    {
        return FiscalYear.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
