/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FiscalYearVariantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FiscalYearVariantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Fiscal Year Variant (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FiscalYearVariant</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FiscalYearVariant extends VdmEntity<FiscalYearVariant>
{

    /**
     * Selector for all available fields of FiscalYearVariant.
     *
     */
    public final static FiscalYearVariantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant_ID</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @Key
    @SerializedName( "FiscalYearVariant_ID" )
    @JsonProperty( "FiscalYearVariant_ID" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant_ID" )
    private String fiscalYearVariant_ID;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant_ID</b> field to query operations.
     *
     */
    public final static FiscalYearVariantField<String> FISCAL_YEAR_VARIANT_ID =
        new FiscalYearVariantField<String>("FiscalYearVariant_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariantText</b>
     * </p>
     *
     * @return Fiscal Year Variant (Description)
     */
    @SerializedName( "FiscalYearVariantText" )
    @JsonProperty( "FiscalYearVariantText" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariantText" )
    private String fiscalYearVariantText;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariantText</b> field to query operations.
     *
     */
    public final static FiscalYearVariantField<String> FISCAL_YEAR_VARIANT_TEXT =
        new FiscalYearVariantField<String>("FiscalYearVariantText");

    @Nonnull
    @Override
    public Class<FiscalYearVariant> getType()
    {
        return FiscalYearVariant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant_ID</b>
     * </p>
     *
     * @param fiscalYearVariant_ID
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant_ID( @Nullable final String fiscalYearVariant_ID )
    {
        rememberChangedField("FiscalYearVariant_ID", this.fiscalYearVariant_ID);
        this.fiscalYearVariant_ID = fiscalYearVariant_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariantText</b>
     * </p>
     *
     * @param fiscalYearVariantText
     *            Fiscal Year Variant (Description)
     */
    public void setFiscalYearVariantText( @Nullable final String fiscalYearVariantText )
    {
        rememberChangedField("FiscalYearVariantText", this.fiscalYearVariantText);
        this.fiscalYearVariantText = fiscalYearVariantText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FiscalYearVariant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FiscalYearVariant_ID", getFiscalYearVariant_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FiscalYearVariant_ID", getFiscalYearVariant_ID());
        values.put("FiscalYearVariantText", getFiscalYearVariantText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FiscalYearVariant_ID") ) {
                final Object value = values.remove("FiscalYearVariant_ID");
                if( (value == null) || (!value.equals(getFiscalYearVariant_ID())) ) {
                    setFiscalYearVariant_ID(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariantText") ) {
                final Object value = values.remove("FiscalYearVariantText");
                if( (value == null) || (!value.equals(getFiscalYearVariantText())) ) {
                    setFiscalYearVariantText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FiscalYearVariantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FiscalYearVariantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FiscalYearVariantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FiscalYearVariantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
