/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency1Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency1Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 1 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency1</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency1 extends VdmEntity<FreeDefinedCurrency1>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency1.
     *
     */
    public final static FreeDefinedCurrency1Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 1
     */
    @Key
    @SerializedName( "FreeDefinedCurrency1_ID" )
    @JsonProperty( "FreeDefinedCurrency1_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1_ID" )
    private String freeDefinedCurrency1_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency1Field<String> FREE_DEFINED_CURRENCY1_I_D =
        new FreeDefinedCurrency1Field<String>("FreeDefinedCurrency1_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1Text</b>
     * </p>
     *
     * @return Freely Defined Currency 1 (Description)
     */
    @SerializedName( "FreeDefinedCurrency1Text" )
    @JsonProperty( "FreeDefinedCurrency1Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1Text" )
    private String freeDefinedCurrency1Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency1Field<String> FREE_DEFINED_CURRENCY1_TEXT =
        new FreeDefinedCurrency1Field<String>("FreeDefinedCurrency1Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency1> getType()
    {
        return FreeDefinedCurrency1.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency1_ID
     *            Freely Defined Currency 1
     */
    public void setFreeDefinedCurrency1_ID( @Nullable final String freeDefinedCurrency1_ID )
    {
        rememberChangedField("FreeDefinedCurrency1_ID", this.freeDefinedCurrency1_ID);
        this.freeDefinedCurrency1_ID = freeDefinedCurrency1_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1Text</b>
     * </p>
     *
     * @param freeDefinedCurrency1Text
     *            Freely Defined Currency 1 (Description)
     */
    public void setFreeDefinedCurrency1Text( @Nullable final String freeDefinedCurrency1Text )
    {
        rememberChangedField("FreeDefinedCurrency1Text", this.freeDefinedCurrency1Text);
        this.freeDefinedCurrency1Text = freeDefinedCurrency1Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency1";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency1_ID", getFreeDefinedCurrency1_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency1_ID", getFreeDefinedCurrency1_ID());
        values.put("FreeDefinedCurrency1Text", getFreeDefinedCurrency1Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency1_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency1_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1_ID())) ) {
                    setFreeDefinedCurrency1_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency1Text") ) {
                final Object value = values.remove("FreeDefinedCurrency1Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1Text())) ) {
                    setFreeDefinedCurrency1Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency1Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency1Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency1Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency1Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
