/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 2 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency2</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency2 extends VdmEntity<FreeDefinedCurrency2>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency2.
     *
     */
    public final static FreeDefinedCurrency2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 2
     */
    @Key
    @SerializedName( "FreeDefinedCurrency2_ID" )
    @JsonProperty( "FreeDefinedCurrency2_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2_ID" )
    private String freeDefinedCurrency2_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency2Field<String> FREE_DEFINED_CURRENCY2_I_D =
        new FreeDefinedCurrency2Field<String>("FreeDefinedCurrency2_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2Text</b>
     * </p>
     *
     * @return Freely Defined Currency 2 (Description)
     */
    @SerializedName( "FreeDefinedCurrency2Text" )
    @JsonProperty( "FreeDefinedCurrency2Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2Text" )
    private String freeDefinedCurrency2Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency2Field<String> FREE_DEFINED_CURRENCY2_TEXT =
        new FreeDefinedCurrency2Field<String>("FreeDefinedCurrency2Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency2> getType()
    {
        return FreeDefinedCurrency2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency2_ID
     *            Freely Defined Currency 2
     */
    public void setFreeDefinedCurrency2_ID( @Nullable final String freeDefinedCurrency2_ID )
    {
        rememberChangedField("FreeDefinedCurrency2_ID", this.freeDefinedCurrency2_ID);
        this.freeDefinedCurrency2_ID = freeDefinedCurrency2_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2Text</b>
     * </p>
     *
     * @param freeDefinedCurrency2Text
     *            Freely Defined Currency 2 (Description)
     */
    public void setFreeDefinedCurrency2Text( @Nullable final String freeDefinedCurrency2Text )
    {
        rememberChangedField("FreeDefinedCurrency2Text", this.freeDefinedCurrency2Text);
        this.freeDefinedCurrency2Text = freeDefinedCurrency2Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency2_ID", getFreeDefinedCurrency2_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency2_ID", getFreeDefinedCurrency2_ID());
        values.put("FreeDefinedCurrency2Text", getFreeDefinedCurrency2Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency2_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency2_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2_ID())) ) {
                    setFreeDefinedCurrency2_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency2Text") ) {
                final Object value = values.remove("FreeDefinedCurrency2Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2Text())) ) {
                    setFreeDefinedCurrency2Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
