/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency3Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency3Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 3 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency3</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency3 extends VdmEntity<FreeDefinedCurrency3>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency3.
     *
     */
    public final static FreeDefinedCurrency3Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 3
     */
    @Key
    @SerializedName( "FreeDefinedCurrency3_ID" )
    @JsonProperty( "FreeDefinedCurrency3_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3_ID" )
    private String freeDefinedCurrency3_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency3Field<String> FREE_DEFINED_CURRENCY3_I_D =
        new FreeDefinedCurrency3Field<String>("FreeDefinedCurrency3_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3Text</b>
     * </p>
     *
     * @return Freely Defined Currency 3 (Description)
     */
    @SerializedName( "FreeDefinedCurrency3Text" )
    @JsonProperty( "FreeDefinedCurrency3Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3Text" )
    private String freeDefinedCurrency3Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency3Field<String> FREE_DEFINED_CURRENCY3_TEXT =
        new FreeDefinedCurrency3Field<String>("FreeDefinedCurrency3Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency3> getType()
    {
        return FreeDefinedCurrency3.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency3_ID
     *            Freely Defined Currency 3
     */
    public void setFreeDefinedCurrency3_ID( @Nullable final String freeDefinedCurrency3_ID )
    {
        rememberChangedField("FreeDefinedCurrency3_ID", this.freeDefinedCurrency3_ID);
        this.freeDefinedCurrency3_ID = freeDefinedCurrency3_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3Text</b>
     * </p>
     *
     * @param freeDefinedCurrency3Text
     *            Freely Defined Currency 3 (Description)
     */
    public void setFreeDefinedCurrency3Text( @Nullable final String freeDefinedCurrency3Text )
    {
        rememberChangedField("FreeDefinedCurrency3Text", this.freeDefinedCurrency3Text);
        this.freeDefinedCurrency3Text = freeDefinedCurrency3Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency3";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency3_ID", getFreeDefinedCurrency3_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency3_ID", getFreeDefinedCurrency3_ID());
        values.put("FreeDefinedCurrency3Text", getFreeDefinedCurrency3Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency3_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency3_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3_ID())) ) {
                    setFreeDefinedCurrency3_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency3Text") ) {
                final Object value = values.remove("FreeDefinedCurrency3Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3Text())) ) {
                    setFreeDefinedCurrency3Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency3Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency3Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency3Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency3Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
