/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency3Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3 FreeDefinedCurrency3}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class FreeDefinedCurrency3ByKeyFluentHelper
    extends
    FluentHelperByKey<FreeDefinedCurrency3ByKeyFluentHelper, FreeDefinedCurrency3, FreeDefinedCurrency3Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3
     * FreeDefinedCurrency3} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FreeDefinedCurrency3}
     * @param freeDefinedCurrency3_ID
     *            Freely Defined Currency 3
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FreeDefinedCurrency3}
     */
    public FreeDefinedCurrency3ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String freeDefinedCurrency3_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("FreeDefinedCurrency3_ID", freeDefinedCurrency3_ID);
    }

    @Override
    @Nonnull
    protected Class<FreeDefinedCurrency3> getEntityClass()
    {
        return FreeDefinedCurrency3.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
