/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency4Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency4Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 4 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency4</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency4 extends VdmEntity<FreeDefinedCurrency4>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency4.
     *
     */
    public final static FreeDefinedCurrency4Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 4
     */
    @Key
    @SerializedName( "FreeDefinedCurrency4_ID" )
    @JsonProperty( "FreeDefinedCurrency4_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4_ID" )
    private String freeDefinedCurrency4_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency4Field<String> FREE_DEFINED_CURRENCY4_I_D =
        new FreeDefinedCurrency4Field<String>("FreeDefinedCurrency4_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4Text</b>
     * </p>
     *
     * @return Freely Defined Currency 4 (Description)
     */
    @SerializedName( "FreeDefinedCurrency4Text" )
    @JsonProperty( "FreeDefinedCurrency4Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4Text" )
    private String freeDefinedCurrency4Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency4Field<String> FREE_DEFINED_CURRENCY4_TEXT =
        new FreeDefinedCurrency4Field<String>("FreeDefinedCurrency4Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency4> getType()
    {
        return FreeDefinedCurrency4.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency4_ID
     *            Freely Defined Currency 4
     */
    public void setFreeDefinedCurrency4_ID( @Nullable final String freeDefinedCurrency4_ID )
    {
        rememberChangedField("FreeDefinedCurrency4_ID", this.freeDefinedCurrency4_ID);
        this.freeDefinedCurrency4_ID = freeDefinedCurrency4_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4Text</b>
     * </p>
     *
     * @param freeDefinedCurrency4Text
     *            Freely Defined Currency 4 (Description)
     */
    public void setFreeDefinedCurrency4Text( @Nullable final String freeDefinedCurrency4Text )
    {
        rememberChangedField("FreeDefinedCurrency4Text", this.freeDefinedCurrency4Text);
        this.freeDefinedCurrency4Text = freeDefinedCurrency4Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency4";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency4_ID", getFreeDefinedCurrency4_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency4_ID", getFreeDefinedCurrency4_ID());
        values.put("FreeDefinedCurrency4Text", getFreeDefinedCurrency4Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency4_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency4_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4_ID())) ) {
                    setFreeDefinedCurrency4_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency4Text") ) {
                final Object value = values.remove("FreeDefinedCurrency4Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4Text())) ) {
                    setFreeDefinedCurrency4Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency4Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency4Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency4Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency4Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
