/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency4Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4 FreeDefinedCurrency4}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class FreeDefinedCurrency4ByKeyFluentHelper
    extends
    FluentHelperByKey<FreeDefinedCurrency4ByKeyFluentHelper, FreeDefinedCurrency4, FreeDefinedCurrency4Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4
     * FreeDefinedCurrency4} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FreeDefinedCurrency4}
     * @param servicePath
     *            Service path to be used to fetch a single {@code FreeDefinedCurrency4}
     * @param freeDefinedCurrency4_ID
     *            Freely Defined Currency 4
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public FreeDefinedCurrency4ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String freeDefinedCurrency4_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("FreeDefinedCurrency4_ID", freeDefinedCurrency4_ID);
    }

    @Override
    @Nonnull
    protected Class<FreeDefinedCurrency4> getEntityClass()
    {
        return FreeDefinedCurrency4.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
