/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency5Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency5Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 5 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency5</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency5 extends VdmEntity<FreeDefinedCurrency5>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency5.
     *
     */
    public final static FreeDefinedCurrency5Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 5
     */
    @Key
    @SerializedName( "FreeDefinedCurrency5_ID" )
    @JsonProperty( "FreeDefinedCurrency5_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5_ID" )
    private String freeDefinedCurrency5_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency5Field<String> FREE_DEFINED_CURRENCY5_I_D =
        new FreeDefinedCurrency5Field<String>("FreeDefinedCurrency5_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5Text</b>
     * </p>
     *
     * @return Freely Defined Currency 5 (Description)
     */
    @SerializedName( "FreeDefinedCurrency5Text" )
    @JsonProperty( "FreeDefinedCurrency5Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5Text" )
    private String freeDefinedCurrency5Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency5Field<String> FREE_DEFINED_CURRENCY5_TEXT =
        new FreeDefinedCurrency5Field<String>("FreeDefinedCurrency5Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency5> getType()
    {
        return FreeDefinedCurrency5.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency5_ID
     *            Freely Defined Currency 5
     */
    public void setFreeDefinedCurrency5_ID( @Nullable final String freeDefinedCurrency5_ID )
    {
        rememberChangedField("FreeDefinedCurrency5_ID", this.freeDefinedCurrency5_ID);
        this.freeDefinedCurrency5_ID = freeDefinedCurrency5_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5Text</b>
     * </p>
     *
     * @param freeDefinedCurrency5Text
     *            Freely Defined Currency 5 (Description)
     */
    public void setFreeDefinedCurrency5Text( @Nullable final String freeDefinedCurrency5Text )
    {
        rememberChangedField("FreeDefinedCurrency5Text", this.freeDefinedCurrency5Text);
        this.freeDefinedCurrency5Text = freeDefinedCurrency5Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency5";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency5_ID", getFreeDefinedCurrency5_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency5_ID", getFreeDefinedCurrency5_ID());
        values.put("FreeDefinedCurrency5Text", getFreeDefinedCurrency5Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency5_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency5_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5_ID())) ) {
                    setFreeDefinedCurrency5_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency5Text") ) {
                final Object value = values.remove("FreeDefinedCurrency5Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5Text())) ) {
                    setFreeDefinedCurrency5Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency5Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency5Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency5Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency5Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
