/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency5Selectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5 FreeDefinedCurrency5}
 * entities. This fluent helper allows methods which modify the underlying query to be called before executing the query
 * itself.
 *
 */
public class FreeDefinedCurrency5FluentHelper
    extends
    FluentHelperRead<FreeDefinedCurrency5FluentHelper, FreeDefinedCurrency5, FreeDefinedCurrency5Selectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public FreeDefinedCurrency5FluentHelper( @Nonnull final String servicePath, @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<FreeDefinedCurrency5> getEntityClass()
    {
        return FreeDefinedCurrency5.class;
    }

}
