/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency6Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6 FreeDefinedCurrency6}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class FreeDefinedCurrency6ByKeyFluentHelper
    extends
    FluentHelperByKey<FreeDefinedCurrency6ByKeyFluentHelper, FreeDefinedCurrency6, FreeDefinedCurrency6Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6
     * FreeDefinedCurrency6} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FreeDefinedCurrency6}
     * @param freeDefinedCurrency6_ID
     *            Freely Defined Currency 6
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FreeDefinedCurrency6}
     */
    public FreeDefinedCurrency6ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String freeDefinedCurrency6_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("FreeDefinedCurrency6_ID", freeDefinedCurrency6_ID);
    }

    @Override
    @Nonnull
    protected Class<FreeDefinedCurrency6> getEntityClass()
    {
        return FreeDefinedCurrency6.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
