/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency7Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency7Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 7 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency7</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency7 extends VdmEntity<FreeDefinedCurrency7>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency7.
     *
     */
    public final static FreeDefinedCurrency7Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 7
     */
    @Key
    @SerializedName( "FreeDefinedCurrency7_ID" )
    @JsonProperty( "FreeDefinedCurrency7_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7_ID" )
    private String freeDefinedCurrency7_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency7Field<String> FREE_DEFINED_CURRENCY7_I_D =
        new FreeDefinedCurrency7Field<String>("FreeDefinedCurrency7_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7Text</b>
     * </p>
     *
     * @return Freely Defined Currency 7 (Description)
     */
    @SerializedName( "FreeDefinedCurrency7Text" )
    @JsonProperty( "FreeDefinedCurrency7Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7Text" )
    private String freeDefinedCurrency7Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency7Field<String> FREE_DEFINED_CURRENCY7_TEXT =
        new FreeDefinedCurrency7Field<String>("FreeDefinedCurrency7Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency7> getType()
    {
        return FreeDefinedCurrency7.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency7_ID
     *            Freely Defined Currency 7
     */
    public void setFreeDefinedCurrency7_ID( @Nullable final String freeDefinedCurrency7_ID )
    {
        rememberChangedField("FreeDefinedCurrency7_ID", this.freeDefinedCurrency7_ID);
        this.freeDefinedCurrency7_ID = freeDefinedCurrency7_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7Text</b>
     * </p>
     *
     * @param freeDefinedCurrency7Text
     *            Freely Defined Currency 7 (Description)
     */
    public void setFreeDefinedCurrency7Text( @Nullable final String freeDefinedCurrency7Text )
    {
        rememberChangedField("FreeDefinedCurrency7Text", this.freeDefinedCurrency7Text);
        this.freeDefinedCurrency7Text = freeDefinedCurrency7Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency7";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency7_ID", getFreeDefinedCurrency7_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency7_ID", getFreeDefinedCurrency7_ID());
        values.put("FreeDefinedCurrency7Text", getFreeDefinedCurrency7Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency7_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency7_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7_ID())) ) {
                    setFreeDefinedCurrency7_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency7Text") ) {
                final Object value = values.remove("FreeDefinedCurrency7Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7Text())) ) {
                    setFreeDefinedCurrency7Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency7Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency7Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency7Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency7Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
