/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency7Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7 FreeDefinedCurrency7}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class FreeDefinedCurrency7ByKeyFluentHelper
    extends
    FluentHelperByKey<FreeDefinedCurrency7ByKeyFluentHelper, FreeDefinedCurrency7, FreeDefinedCurrency7Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7
     * FreeDefinedCurrency7} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FreeDefinedCurrency7}
     * @param freeDefinedCurrency7_ID
     *            Freely Defined Currency 7
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code FreeDefinedCurrency7}
     */
    public FreeDefinedCurrency7ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String freeDefinedCurrency7_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("FreeDefinedCurrency7_ID", freeDefinedCurrency7_ID);
    }

    @Override
    @Nonnull
    protected Class<FreeDefinedCurrency7> getEntityClass()
    {
        return FreeDefinedCurrency7.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
