/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FreeDefinedCurrency8Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency8Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Freely Defined Currency 8 (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FreeDefinedCurrency8</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FreeDefinedCurrency8 extends VdmEntity<FreeDefinedCurrency8>
{

    /**
     * Selector for all available fields of FreeDefinedCurrency8.
     *
     */
    public final static FreeDefinedCurrency8Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8_ID</b>
     * </p>
     *
     * @return Freely Defined Currency 8
     */
    @Key
    @SerializedName( "FreeDefinedCurrency8_ID" )
    @JsonProperty( "FreeDefinedCurrency8_ID" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8_ID" )
    private String freeDefinedCurrency8_ID;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8_ID</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency8Field<String> FREE_DEFINED_CURRENCY8_I_D =
        new FreeDefinedCurrency8Field<String>("FreeDefinedCurrency8_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8Text</b>
     * </p>
     *
     * @return Freely Defined Currency 8 (Description)
     */
    @SerializedName( "FreeDefinedCurrency8Text" )
    @JsonProperty( "FreeDefinedCurrency8Text" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8Text" )
    private String freeDefinedCurrency8Text;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8Text</b> field to query operations.
     *
     */
    public final static FreeDefinedCurrency8Field<String> FREE_DEFINED_CURRENCY8_TEXT =
        new FreeDefinedCurrency8Field<String>("FreeDefinedCurrency8Text");

    @Nonnull
    @Override
    public Class<FreeDefinedCurrency8> getType()
    {
        return FreeDefinedCurrency8.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8_ID</b>
     * </p>
     *
     * @param freeDefinedCurrency8_ID
     *            Freely Defined Currency 8
     */
    public void setFreeDefinedCurrency8_ID( @Nullable final String freeDefinedCurrency8_ID )
    {
        rememberChangedField("FreeDefinedCurrency8_ID", this.freeDefinedCurrency8_ID);
        this.freeDefinedCurrency8_ID = freeDefinedCurrency8_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8Text</b>
     * </p>
     *
     * @param freeDefinedCurrency8Text
     *            Freely Defined Currency 8 (Description)
     */
    public void setFreeDefinedCurrency8Text( @Nullable final String freeDefinedCurrency8Text )
    {
        rememberChangedField("FreeDefinedCurrency8Text", this.freeDefinedCurrency8Text);
        this.freeDefinedCurrency8Text = freeDefinedCurrency8Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FreeDefinedCurrency8";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FreeDefinedCurrency8_ID", getFreeDefinedCurrency8_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FreeDefinedCurrency8_ID", getFreeDefinedCurrency8_ID());
        values.put("FreeDefinedCurrency8Text", getFreeDefinedCurrency8Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FreeDefinedCurrency8_ID") ) {
                final Object value = values.remove("FreeDefinedCurrency8_ID");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8_ID())) ) {
                    setFreeDefinedCurrency8_ID(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency8Text") ) {
                final Object value = values.remove("FreeDefinedCurrency8Text");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8Text())) ) {
                    setFreeDefinedCurrency8Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FreeDefinedCurrency8Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FreeDefinedCurrency8Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FreeDefinedCurrency8Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FreeDefinedCurrency8Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
