/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency8Selectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8 FreeDefinedCurrency8}
 * entities. This fluent helper allows methods which modify the underlying query to be called before executing the query
 * itself.
 *
 */
public class FreeDefinedCurrency8FluentHelper
    extends
    FluentHelperRead<FreeDefinedCurrency8FluentHelper, FreeDefinedCurrency8, FreeDefinedCurrency8Selectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public FreeDefinedCurrency8FluentHelper( @Nonnull final String servicePath, @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<FreeDefinedCurrency8> getEntityClass()
    {
        return FreeDefinedCurrency8.class;
    }

}
