/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FunctionalAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FunctionalAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Functional Area (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FunctionalArea</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionalArea extends VdmEntity<FunctionalArea>
{

    /**
     * Selector for all available fields of FunctionalArea.
     *
     */
    public final static FunctionalAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_ID</b>
     * </p>
     *
     * @return Functional Area
     */
    @Key
    @SerializedName( "FunctionalArea_ID" )
    @JsonProperty( "FunctionalArea_ID" )
    @Nullable
    @ODataField( odataName = "FunctionalArea_ID" )
    private String functionalArea_ID;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea_ID</b> field to query operations.
     *
     */
    public final static FunctionalAreaField<String> FUNCTIONAL_AREA_ID =
        new FunctionalAreaField<String>("FunctionalArea_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaText</b>
     * </p>
     *
     * @return Functional Area (Description)
     */
    @SerializedName( "FunctionalAreaText" )
    @JsonProperty( "FunctionalAreaText" )
    @Nullable
    @ODataField( odataName = "FunctionalAreaText" )
    private String functionalAreaText;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaText</b> field to query operations.
     *
     */
    public final static FunctionalAreaField<String> FUNCTIONAL_AREA_TEXT =
        new FunctionalAreaField<String>("FunctionalAreaText");

    @Nonnull
    @Override
    public Class<FunctionalArea> getType()
    {
        return FunctionalArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_ID</b>
     * </p>
     *
     * @param functionalArea_ID
     *            Functional Area
     */
    public void setFunctionalArea_ID( @Nullable final String functionalArea_ID )
    {
        rememberChangedField("FunctionalArea_ID", this.functionalArea_ID);
        this.functionalArea_ID = functionalArea_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaText</b>
     * </p>
     *
     * @param functionalAreaText
     *            Functional Area (Description)
     */
    public void setFunctionalAreaText( @Nullable final String functionalAreaText )
    {
        rememberChangedField("FunctionalAreaText", this.functionalAreaText);
        this.functionalAreaText = functionalAreaText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FunctionalArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FunctionalArea_ID", getFunctionalArea_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FunctionalArea_ID", getFunctionalArea_ID());
        values.put("FunctionalAreaText", getFunctionalAreaText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FunctionalArea_ID") ) {
                final Object value = values.remove("FunctionalArea_ID");
                if( (value == null) || (!value.equals(getFunctionalArea_ID())) ) {
                    setFunctionalArea_ID(((String) value));
                }
            }
            if( values.containsKey("FunctionalAreaText") ) {
                final Object value = values.remove("FunctionalAreaText");
                if( (value == null) || (!value.equals(getFunctionalAreaText())) ) {
                    setFunctionalAreaText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FunctionalAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FunctionalAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FunctionalAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FunctionalAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
