/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.FundField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FundSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Fund
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Fund</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Fund extends VdmEntity<Fund>
{

    /**
     * Selector for all available fields of Fund.
     *
     */
    public final static FundSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @Key
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static FundField<String> FUND = new FundField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FundText</b>
     * </p>
     *
     * @return Fund (Description)
     */
    @SerializedName( "FundText" )
    @JsonProperty( "FundText" )
    @Nullable
    @ODataField( odataName = "FundText" )
    private String fundText;
    /**
     * Use with available fluent helpers to apply the <b>FundText</b> field to query operations.
     *
     */
    public final static FundField<String> FUND_TEXT = new FundField<String>("FundText");

    @Nonnull
    @Override
    public Class<Fund> getType()
    {
        return Fund.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FundText</b>
     * </p>
     *
     * @param fundText
     *            Fund (Description)
     */
    public void setFundText( @Nullable final String fundText )
    {
        rememberChangedField("FundText", this.fundText);
        this.fundText = fundText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Fund";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Fund", getFund());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Fund", getFund());
        values.put("FundText", getFundText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FundText") ) {
                final Object value = values.remove("FundText");
                if( (value == null) || (!value.equals(getFundText())) ) {
                    setFundText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FundField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FundField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FundField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FundField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
