/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GLAccountHierarchyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GLAccountHierarchySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * G/L Account (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLAccountHierarchy</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccountHierarchy extends VdmEntity<GLAccountHierarchy>
{

    /**
     * Selector for all available fields of GLAccountHierarchy.
     *
     */
    public final static GLAccountHierarchySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy_ID</b>
     * </p>
     *
     * @return G/L Account
     */
    @Key
    @SerializedName( "GLAccountHierarchy_ID" )
    @JsonProperty( "GLAccountHierarchy_ID" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchy_ID" )
    private String gLAccountHierarchy_ID;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchy_ID</b> field to query operations.
     *
     */
    public final static GLAccountHierarchyField<String> GL_ACCOUNT_HIERARCHY_ID =
        new GLAccountHierarchyField<String>("GLAccountHierarchy_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchyText</b>
     * </p>
     *
     * @return G/L Account (Description)
     */
    @SerializedName( "GLAccountHierarchyText" )
    @JsonProperty( "GLAccountHierarchyText" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchyText" )
    private String gLAccountHierarchyText;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchyText</b> field to query operations.
     *
     */
    public final static GLAccountHierarchyField<String> GL_ACCOUNT_HIERARCHY_TEXT =
        new GLAccountHierarchyField<String>("GLAccountHierarchyText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return G/L Account (Chart of Accounts)
     */
    @Key
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static GLAccountHierarchyField<String> CHART_OF_ACCOUNTS =
        new GLAccountHierarchyField<String>("ChartOfAccounts");

    @Nonnull
    @Override
    public Class<GLAccountHierarchy> getType()
    {
        return GLAccountHierarchy.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy_ID</b>
     * </p>
     *
     * @param gLAccountHierarchy_ID
     *            G/L Account
     */
    public void setGLAccountHierarchy_ID( @Nullable final String gLAccountHierarchy_ID )
    {
        rememberChangedField("GLAccountHierarchy_ID", this.gLAccountHierarchy_ID);
        this.gLAccountHierarchy_ID = gLAccountHierarchy_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchyText</b>
     * </p>
     *
     * @param gLAccountHierarchyText
     *            G/L Account (Description)
     */
    public void setGLAccountHierarchyText( @Nullable final String gLAccountHierarchyText )
    {
        rememberChangedField("GLAccountHierarchyText", this.gLAccountHierarchyText);
        this.gLAccountHierarchyText = gLAccountHierarchyText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            G/L Account (Chart of Accounts)
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GLAccountHierarchy";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GLAccountHierarchy_ID", getGLAccountHierarchy_ID());
        result.put("ChartOfAccounts", getChartOfAccounts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GLAccountHierarchy_ID", getGLAccountHierarchy_ID());
        values.put("GLAccountHierarchyText", getGLAccountHierarchyText());
        values.put("ChartOfAccounts", getChartOfAccounts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GLAccountHierarchy_ID") ) {
                final Object value = values.remove("GLAccountHierarchy_ID");
                if( (value == null) || (!value.equals(getGLAccountHierarchy_ID())) ) {
                    setGLAccountHierarchy_ID(((String) value));
                }
            }
            if( values.containsKey("GLAccountHierarchyText") ) {
                final Object value = values.remove("GLAccountHierarchyText");
                if( (value == null) || (!value.equals(getGLAccountHierarchyText())) ) {
                    setGLAccountHierarchyText(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GLAccountHierarchyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GLAccountHierarchyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccountHierarchyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccountHierarchyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
