/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GLAccountHierarchySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy GLAccountHierarchy} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class GLAccountHierarchyByKeyFluentHelper
    extends
    FluentHelperByKey<GLAccountHierarchyByKeyFluentHelper, GLAccountHierarchy, GLAccountHierarchySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy GLAccountHierarchy}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GLAccountHierarchy}
     * @param servicePath
     *            Service path to be used to fetch a single {@code GLAccountHierarchy}
     * @param chartOfAccounts
     *            G/L Account (Chart of Accounts)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param gLAccountHierarchy_ID
     *            G/L Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public GLAccountHierarchyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String gLAccountHierarchy_ID,
        final String chartOfAccounts )
    {
        super(servicePath, entityCollection);
        this.key.put("GLAccountHierarchy_ID", gLAccountHierarchy_ID);
        this.key.put("ChartOfAccounts", chartOfAccounts);
    }

    @Override
    @Nonnull
    protected Class<GLAccountHierarchy> getEntityClass()
    {
        return GLAccountHierarchy.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
