/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GLAccount_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GLAccount_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * G/L Account Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GLAccount_2 extends VdmEntity<GLAccount_2>
{

    /**
     * Selector for all available fields of GLAccount_2.
     *
     */
    public final static GLAccount_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType_ID</b>
     * </p>
     *
     * @return G/L Account Type
     */
    @Key
    @SerializedName( "GLAccountType_ID" )
    @JsonProperty( "GLAccountType_ID" )
    @Nullable
    @ODataField( odataName = "GLAccountType_ID" )
    private String gLAccountType_ID;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountType_ID</b> field to query operations.
     *
     */
    public final static GLAccount_2Field<String> GL_ACCOUNT_TYPE_ID = new GLAccount_2Field<String>("GLAccountType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountTypeText</b>
     * </p>
     *
     * @return G/L Account Type (Description)
     */
    @SerializedName( "GLAccountTypeText" )
    @JsonProperty( "GLAccountTypeText" )
    @Nullable
    @ODataField( odataName = "GLAccountTypeText" )
    private String gLAccountTypeText;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountTypeText</b> field to query operations.
     *
     */
    public final static GLAccount_2Field<String> GL_ACCOUNT_TYPE_TEXT =
        new GLAccount_2Field<String>("GLAccountTypeText");

    @Nonnull
    @Override
    public Class<GLAccount_2> getType()
    {
        return GLAccount_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType_ID</b>
     * </p>
     *
     * @param gLAccountType_ID
     *            G/L Account Type
     */
    public void setGLAccountType_ID( @Nullable final String gLAccountType_ID )
    {
        rememberChangedField("GLAccountType_ID", this.gLAccountType_ID);
        this.gLAccountType_ID = gLAccountType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountTypeText</b>
     * </p>
     *
     * @param gLAccountTypeText
     *            G/L Account Type (Description)
     */
    public void setGLAccountTypeText( @Nullable final String gLAccountTypeText )
    {
        rememberChangedField("GLAccountTypeText", this.gLAccountTypeText);
        this.gLAccountTypeText = gLAccountTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GLAccountType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GLAccountType_ID", getGLAccountType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GLAccountType_ID", getGLAccountType_ID());
        values.put("GLAccountTypeText", getGLAccountTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GLAccountType_ID") ) {
                final Object value = values.remove("GLAccountType_ID");
                if( (value == null) || (!value.equals(getGLAccountType_ID())) ) {
                    setGLAccountType_ID(((String) value));
                }
            }
            if( values.containsKey("GLAccountTypeText") ) {
                final Object value = values.remove("GLAccountTypeText");
                if( (value == null) || (!value.equals(getGLAccountTypeText())) ) {
                    setGLAccountTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GLAccount_2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GLAccount_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GLAccount_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GLAccount_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
