/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GLAccount_2Selectable;

/**
 * Fluent helper to fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2
 * GLAccount_2} entities. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class GLAccount_2FluentHelper
    extends
    FluentHelperRead<GLAccount_2FluentHelper, GLAccount_2, GLAccount_2Selectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public GLAccount_2FluentHelper( @Nonnull final String servicePath, @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<GLAccount_2> getEntityClass()
    {
        return GLAccount_2.class;
    }

}
