/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GlobalCurrencyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GlobalCurrencySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Global Currency (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GlobalCurrency</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GlobalCurrency extends VdmEntity<GlobalCurrency>
{

    /**
     * Selector for all available fields of GlobalCurrency.
     *
     */
    public final static GlobalCurrencySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency_ID</b>
     * </p>
     *
     * @return Global Currency
     */
    @Key
    @SerializedName( "GlobalCurrency_ID" )
    @JsonProperty( "GlobalCurrency_ID" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency_ID" )
    private String globalCurrency_ID;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency_ID</b> field to query operations.
     *
     */
    public final static GlobalCurrencyField<String> GLOBAL_CURRENCY_ID =
        new GlobalCurrencyField<String>("GlobalCurrency_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrencyText</b>
     * </p>
     *
     * @return Global Currency (Description)
     */
    @SerializedName( "GlobalCurrencyText" )
    @JsonProperty( "GlobalCurrencyText" )
    @Nullable
    @ODataField( odataName = "GlobalCurrencyText" )
    private String globalCurrencyText;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrencyText</b> field to query operations.
     *
     */
    public final static GlobalCurrencyField<String> GLOBAL_CURRENCY_TEXT =
        new GlobalCurrencyField<String>("GlobalCurrencyText");

    @Nonnull
    @Override
    public Class<GlobalCurrency> getType()
    {
        return GlobalCurrency.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency_ID</b>
     * </p>
     *
     * @param globalCurrency_ID
     *            Global Currency
     */
    public void setGlobalCurrency_ID( @Nullable final String globalCurrency_ID )
    {
        rememberChangedField("GlobalCurrency_ID", this.globalCurrency_ID);
        this.globalCurrency_ID = globalCurrency_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrencyText</b>
     * </p>
     *
     * @param globalCurrencyText
     *            Global Currency (Description)
     */
    public void setGlobalCurrencyText( @Nullable final String globalCurrencyText )
    {
        rememberChangedField("GlobalCurrencyText", this.globalCurrencyText);
        this.globalCurrencyText = globalCurrencyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GlobalCurrency";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GlobalCurrency_ID", getGlobalCurrency_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GlobalCurrency_ID", getGlobalCurrency_ID());
        values.put("GlobalCurrencyText", getGlobalCurrencyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GlobalCurrency_ID") ) {
                final Object value = values.remove("GlobalCurrency_ID");
                if( (value == null) || (!value.equals(getGlobalCurrency_ID())) ) {
                    setGlobalCurrency_ID(((String) value));
                }
            }
            if( values.containsKey("GlobalCurrencyText") ) {
                final Object value = values.remove("GlobalCurrencyText");
                if( (value == null) || (!value.equals(getGlobalCurrencyText())) ) {
                    setGlobalCurrencyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> GlobalCurrencyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GlobalCurrencyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GlobalCurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GlobalCurrencyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
