/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.GroupFixedAssetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GroupFixedAssetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Group Asset Subnmbr (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GroupFixedAsset</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GroupFixedAsset extends VdmEntity<GroupFixedAsset>
{

    /**
     * Selector for all available fields of GroupFixedAsset.
     *
     */
    public final static GroupFixedAssetSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset_ID</b>
     * </p>
     *
     * @return Group Asset Subnmbr
     */
    @Key
    @SerializedName( "GroupFixedAsset_ID" )
    @JsonProperty( "GroupFixedAsset_ID" )
    @Nullable
    @ODataField( odataName = "GroupFixedAsset_ID" )
    private String groupFixedAsset_ID;
    /**
     * Use with available fluent helpers to apply the <b>GroupFixedAsset_ID</b> field to query operations.
     *
     */
    public final static GroupFixedAssetField<String> GROUP_FIXED_ASSET_ID =
        new GroupFixedAssetField<String>("GroupFixedAsset_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAssetText</b>
     * </p>
     *
     * @return Group Asset Subnmbr (Description)
     */
    @SerializedName( "GroupFixedAssetText" )
    @JsonProperty( "GroupFixedAssetText" )
    @Nullable
    @ODataField( odataName = "GroupFixedAssetText" )
    private String groupFixedAssetText;
    /**
     * Use with available fluent helpers to apply the <b>GroupFixedAssetText</b> field to query operations.
     *
     */
    public final static GroupFixedAssetField<String> GROUP_FIXED_ASSET_TEXT =
        new GroupFixedAssetField<String>("GroupFixedAssetText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Group Asset Subnmbr (Company Code)
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static GroupFixedAssetField<String> COMPANY_CODE = new GroupFixedAssetField<String>("CompanyCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code (Description) (Parent Description)
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static GroupFixedAssetField<String> COMPANY_CODE_NAME =
        new GroupFixedAssetField<String>("CompanyCodeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @return Group Asset Subnmbr (Group Asset)
     */
    @Key
    @SerializedName( "GroupMasterFixedAsset" )
    @JsonProperty( "GroupMasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupMasterFixedAsset" )
    private String groupMasterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupMasterFixedAsset</b> field to query operations.
     *
     */
    public final static GroupFixedAssetField<String> GROUP_MASTER_FIXED_ASSET =
        new GroupFixedAssetField<String>("GroupMasterFixedAsset");

    @Nonnull
    @Override
    public Class<GroupFixedAsset> getType()
    {
        return GroupFixedAsset.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset_ID</b>
     * </p>
     *
     * @param groupFixedAsset_ID
     *            Group Asset Subnmbr
     */
    public void setGroupFixedAsset_ID( @Nullable final String groupFixedAsset_ID )
    {
        rememberChangedField("GroupFixedAsset_ID", this.groupFixedAsset_ID);
        this.groupFixedAsset_ID = groupFixedAsset_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAssetText</b>
     * </p>
     *
     * @param groupFixedAssetText
     *            Group Asset Subnmbr (Description)
     */
    public void setGroupFixedAssetText( @Nullable final String groupFixedAssetText )
    {
        rememberChangedField("GroupFixedAssetText", this.groupFixedAssetText);
        this.groupFixedAssetText = groupFixedAssetText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Group Asset Subnmbr (Company Code)
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code (Description) (Parent Description)
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @param groupMasterFixedAsset
     *            Group Asset Subnmbr (Group Asset)
     */
    public void setGroupMasterFixedAsset( @Nullable final String groupMasterFixedAsset )
    {
        rememberChangedField("GroupMasterFixedAsset", this.groupMasterFixedAsset);
        this.groupMasterFixedAsset = groupMasterFixedAsset;
    }

    @Override
    protected String getEntityCollection()
    {
        return "GroupFixedAsset";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("GroupFixedAsset_ID", getGroupFixedAsset_ID());
        result.put("CompanyCode", getCompanyCode());
        result.put("GroupMasterFixedAsset", getGroupMasterFixedAsset());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("GroupFixedAsset_ID", getGroupFixedAsset_ID());
        values.put("GroupFixedAssetText", getGroupFixedAssetText());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("GroupMasterFixedAsset", getGroupMasterFixedAsset());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("GroupFixedAsset_ID") ) {
                final Object value = values.remove("GroupFixedAsset_ID");
                if( (value == null) || (!value.equals(getGroupFixedAsset_ID())) ) {
                    setGroupFixedAsset_ID(((String) value));
                }
            }
            if( values.containsKey("GroupFixedAssetText") ) {
                final Object value = values.remove("GroupFixedAssetText");
                if( (value == null) || (!value.equals(getGroupFixedAssetText())) ) {
                    setGroupFixedAssetText(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("GroupMasterFixedAsset") ) {
                final Object value = values.remove("GroupMasterFixedAsset");
                if( (value == null) || (!value.equals(getGroupMasterFixedAsset())) ) {
                    setGroupMasterFixedAsset(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> GroupFixedAssetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new GroupFixedAssetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> GroupFixedAssetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new GroupFixedAssetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
