/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.GroupFixedAssetSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAsset GroupFixedAsset} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class GroupFixedAssetByKeyFluentHelper
    extends
    FluentHelperByKey<GroupFixedAssetByKeyFluentHelper, GroupFixedAsset, GroupFixedAssetSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAsset GroupFixedAsset} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param companyCode
     *            Group Asset Subnmbr (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GroupFixedAsset}
     * @param groupFixedAsset_ID
     *            Group Asset Subnmbr
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code GroupFixedAsset}
     * @param groupMasterFixedAsset
     *            Group Asset Subnmbr (Group Asset)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public GroupFixedAssetByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String groupFixedAsset_ID,
        final String companyCode,
        final String groupMasterFixedAsset )
    {
        super(servicePath, entityCollection);
        this.key.put("GroupFixedAsset_ID", groupFixedAsset_ID);
        this.key.put("CompanyCode", companyCode);
        this.key.put("GroupMasterFixedAsset", groupMasterFixedAsset);
    }

    @Override
    @Nonnull
    protected Class<GroupFixedAsset> getEntityClass()
    {
        return GroupFixedAsset.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
