/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.HouseBankAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.HouseBankAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * House Bank Account (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>HouseBankAccount</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class HouseBankAccount extends VdmEntity<HouseBankAccount>
{

    /**
     * Selector for all available fields of HouseBankAccount.
     *
     */
    public final static HouseBankAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount_ID</b>
     * </p>
     *
     * @return House Bank Account
     */
    @Key
    @SerializedName( "HouseBankAccount_ID" )
    @JsonProperty( "HouseBankAccount_ID" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount_ID" )
    private String houseBankAccount_ID;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount_ID</b> field to query operations.
     *
     */
    public final static HouseBankAccountField<String> HOUSE_BANK_ACCOUNT_ID =
        new HouseBankAccountField<String>("HouseBankAccount_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccountText</b>
     * </p>
     *
     * @return House Bank Account (Description)
     */
    @SerializedName( "HouseBankAccountText" )
    @JsonProperty( "HouseBankAccountText" )
    @Nullable
    @ODataField( odataName = "HouseBankAccountText" )
    private String houseBankAccountText;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccountText</b> field to query operations.
     *
     */
    public final static HouseBankAccountField<String> HOUSE_BANK_ACCOUNT_TEXT =
        new HouseBankAccountField<String>("HouseBankAccountText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return House Bank Account (Company Code)
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static HouseBankAccountField<String> COMPANY_CODE = new HouseBankAccountField<String>("CompanyCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code (Description) (Parent Description)
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static HouseBankAccountField<String> COMPANY_CODE_NAME =
        new HouseBankAccountField<String>("CompanyCodeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank Account (House Bank)
     */
    @Key
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static HouseBankAccountField<String> HOUSE_BANK = new HouseBankAccountField<String>("HouseBank");

    @Nonnull
    @Override
    public Class<HouseBankAccount> getType()
    {
        return HouseBankAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount_ID</b>
     * </p>
     *
     * @param houseBankAccount_ID
     *            House Bank Account
     */
    public void setHouseBankAccount_ID( @Nullable final String houseBankAccount_ID )
    {
        rememberChangedField("HouseBankAccount_ID", this.houseBankAccount_ID);
        this.houseBankAccount_ID = houseBankAccount_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccountText</b>
     * </p>
     *
     * @param houseBankAccountText
     *            House Bank Account (Description)
     */
    public void setHouseBankAccountText( @Nullable final String houseBankAccountText )
    {
        rememberChangedField("HouseBankAccountText", this.houseBankAccountText);
        this.houseBankAccountText = houseBankAccountText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            House Bank Account (Company Code)
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code (Description) (Parent Description)
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank Account (House Bank)
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    @Override
    protected String getEntityCollection()
    {
        return "HouseBankAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("HouseBankAccount_ID", getHouseBankAccount_ID());
        result.put("CompanyCode", getCompanyCode());
        result.put("HouseBank", getHouseBank());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("HouseBankAccount_ID", getHouseBankAccount_ID());
        values.put("HouseBankAccountText", getHouseBankAccountText());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("HouseBank", getHouseBank());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("HouseBankAccount_ID") ) {
                final Object value = values.remove("HouseBankAccount_ID");
                if( (value == null) || (!value.equals(getHouseBankAccount_ID())) ) {
                    setHouseBankAccount_ID(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccountText") ) {
                final Object value = values.remove("HouseBankAccountText");
                if( (value == null) || (!value.equals(getHouseBankAccountText())) ) {
                    setHouseBankAccountText(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> HouseBankAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new HouseBankAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> HouseBankAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new HouseBankAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
