/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpclStkSalesDocItmField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpclStkSalesDocItmSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inventory Spcl Stock Sales Document Item (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InventorySpclStkSalesDocItm extends VdmEntity<InventorySpclStkSalesDocItm>
{

    /**
     * Selector for all available fields of InventorySpclStkSalesDocItm.
     *
     */
    public final static InventorySpclStkSalesDocItmSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm_ID</b>
     * </p>
     *
     * @return Inventory Spcl Stock Sales Document Item
     */
    @Key
    @SerializedName( "InventorySpclStkSalesDocItm_ID" )
    @JsonProperty( "InventorySpclStkSalesDocItm_ID" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocItm_ID" )
    private String inventorySpclStkSalesDocItm_ID;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocItm_ID</b> field to query operations.
     *
     */
    public final static InventorySpclStkSalesDocItmField<String> INVENTORY_SPCL_STK_SALES_DOC_ITM_ID =
        new InventorySpclStkSalesDocItmField<String>("InventorySpclStkSalesDocItm_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItmText</b>
     * </p>
     *
     * @return Inventory Spcl Stock Sales Document Item (Description)
     */
    @SerializedName( "InventorySpclStkSalesDocItmText" )
    @JsonProperty( "InventorySpclStkSalesDocItmText" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocItmText" )
    private String inventorySpclStkSalesDocItmText;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocItmText</b> field to query operations.
     *
     */
    public final static InventorySpclStkSalesDocItmField<String> INVENTORY_SPCL_STK_SALES_DOC_ITM_TEXT =
        new InventorySpclStkSalesDocItmField<String>("InventorySpclStkSalesDocItmText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @return Inventory Spcl Stock Sales Document Item (Inventory Special Stock Sales Document)
     */
    @Key
    @SerializedName( "InventorySpclStkSalesDocument" )
    @JsonProperty( "InventorySpclStkSalesDocument" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocument" )
    private String inventorySpclStkSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocument</b> field to query operations.
     *
     */
    public final static InventorySpclStkSalesDocItmField<String> INVENTORY_SPCL_STK_SALES_DOCUMENT =
        new InventorySpclStkSalesDocItmField<String>("InventorySpclStkSalesDocument");

    @Nonnull
    @Override
    public Class<InventorySpclStkSalesDocItm> getType()
    {
        return InventorySpclStkSalesDocItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm_ID</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocItm_ID
     *            Inventory Spcl Stock Sales Document Item
     */
    public void setInventorySpclStkSalesDocItm_ID( @Nullable final String inventorySpclStkSalesDocItm_ID )
    {
        rememberChangedField("InventorySpclStkSalesDocItm_ID", this.inventorySpclStkSalesDocItm_ID);
        this.inventorySpclStkSalesDocItm_ID = inventorySpclStkSalesDocItm_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItmText</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocItmText
     *            Inventory Spcl Stock Sales Document Item (Description)
     */
    public void setInventorySpclStkSalesDocItmText( @Nullable final String inventorySpclStkSalesDocItmText )
    {
        rememberChangedField("InventorySpclStkSalesDocItmText", this.inventorySpclStkSalesDocItmText);
        this.inventorySpclStkSalesDocItmText = inventorySpclStkSalesDocItmText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocument
     *            Inventory Spcl Stock Sales Document Item (Inventory Special Stock Sales Document)
     */
    public void setInventorySpclStkSalesDocument( @Nullable final String inventorySpclStkSalesDocument )
    {
        rememberChangedField("InventorySpclStkSalesDocument", this.inventorySpclStkSalesDocument);
        this.inventorySpclStkSalesDocument = inventorySpclStkSalesDocument;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InventorySpclStkSalesDocItm";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InventorySpclStkSalesDocItm_ID", getInventorySpclStkSalesDocItm_ID());
        result.put("InventorySpclStkSalesDocument", getInventorySpclStkSalesDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InventorySpclStkSalesDocItm_ID", getInventorySpclStkSalesDocItm_ID());
        values.put("InventorySpclStkSalesDocItmText", getInventorySpclStkSalesDocItmText());
        values.put("InventorySpclStkSalesDocument", getInventorySpclStkSalesDocument());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InventorySpclStkSalesDocItm_ID") ) {
                final Object value = values.remove("InventorySpclStkSalesDocItm_ID");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocItm_ID())) ) {
                    setInventorySpclStkSalesDocItm_ID(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocItmText") ) {
                final Object value = values.remove("InventorySpclStkSalesDocItmText");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocItmText())) ) {
                    setInventorySpclStkSalesDocItmText(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocument") ) {
                final Object value = values.remove("InventorySpclStkSalesDocument");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocument())) ) {
                    setInventorySpclStkSalesDocument(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InventorySpclStkSalesDocItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InventorySpclStkSalesDocItmField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InventorySpclStkSalesDocItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InventorySpclStkSalesDocItmField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
