/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpclStockWBSElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpclStockWBSElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * WBSElem of Inventory (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InventorySpclStockWBSElement</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InventorySpclStockWBSElement extends VdmEntity<InventorySpclStockWBSElement>
{

    /**
     * Selector for all available fields of InventorySpclStockWBSElement.
     *
     */
    public final static InventorySpclStockWBSElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElement_ID</b>
     * </p>
     *
     * @return WBSElem of Inventory
     */
    @Key
    @SerializedName( "InventorySpclStockWBSElement_ID" )
    @JsonProperty( "InventorySpclStockWBSElement_ID" )
    @Nullable
    @ODataField( odataName = "InventorySpclStockWBSElement_ID" )
    private String inventorySpclStockWBSElement_ID;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStockWBSElement_ID</b> field to query operations.
     *
     */
    public final static InventorySpclStockWBSElementField<String> INVENTORY_SPCL_STOCK_WBS_ELEMENT_ID =
        new InventorySpclStockWBSElementField<String>("InventorySpclStockWBSElement_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElementText</b>
     * </p>
     *
     * @return WBSElem of Inventory (Description)
     */
    @SerializedName( "InventorySpclStockWBSElementText" )
    @JsonProperty( "InventorySpclStockWBSElementText" )
    @Nullable
    @ODataField( odataName = "InventorySpclStockWBSElementText" )
    private String inventorySpclStockWBSElementText;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStockWBSElementText</b> field to query operations.
     *
     */
    public final static InventorySpclStockWBSElementField<String> INVENTORY_SPCL_STOCK_WBS_ELEMENT_TEXT =
        new InventorySpclStockWBSElementField<String>("InventorySpclStockWBSElementText");

    @Nonnull
    @Override
    public Class<InventorySpclStockWBSElement> getType()
    {
        return InventorySpclStockWBSElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElement_ID</b>
     * </p>
     *
     * @param inventorySpclStockWBSElement_ID
     *            WBSElem of Inventory
     */
    public void setInventorySpclStockWBSElement_ID( @Nullable final String inventorySpclStockWBSElement_ID )
    {
        rememberChangedField("InventorySpclStockWBSElement_ID", this.inventorySpclStockWBSElement_ID);
        this.inventorySpclStockWBSElement_ID = inventorySpclStockWBSElement_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElementText</b>
     * </p>
     *
     * @param inventorySpclStockWBSElementText
     *            WBSElem of Inventory (Description)
     */
    public void setInventorySpclStockWBSElementText( @Nullable final String inventorySpclStockWBSElementText )
    {
        rememberChangedField("InventorySpclStockWBSElementText", this.inventorySpclStockWBSElementText);
        this.inventorySpclStockWBSElementText = inventorySpclStockWBSElementText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InventorySpclStockWBSElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InventorySpclStockWBSElement_ID", getInventorySpclStockWBSElement_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InventorySpclStockWBSElement_ID", getInventorySpclStockWBSElement_ID());
        values.put("InventorySpclStockWBSElementText", getInventorySpclStockWBSElementText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InventorySpclStockWBSElement_ID") ) {
                final Object value = values.remove("InventorySpclStockWBSElement_ID");
                if( (value == null) || (!value.equals(getInventorySpclStockWBSElement_ID())) ) {
                    setInventorySpclStockWBSElement_ID(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStockWBSElementText") ) {
                final Object value = values.remove("InventorySpclStockWBSElementText");
                if( (value == null) || (!value.equals(getInventorySpclStockWBSElementText())) ) {
                    setInventorySpclStockWBSElementText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InventorySpclStockWBSElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InventorySpclStockWBSElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InventorySpclStockWBSElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InventorySpclStockWBSElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
