/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpecialStockField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpecialStockSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inventory Special Stock Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InventorySpecialStockType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InventorySpecialStock extends VdmEntity<InventorySpecialStock>
{

    /**
     * Selector for all available fields of InventorySpecialStock.
     *
     */
    public final static InventorySpecialStockSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType_ID</b>
     * </p>
     *
     * @return Inventory Special Stock Type
     */
    @Key
    @SerializedName( "InventorySpecialStockType_ID" )
    @JsonProperty( "InventorySpecialStockType_ID" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType_ID" )
    private String inventorySpecialStockType_ID;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType_ID</b> field to query operations.
     *
     */
    public final static InventorySpecialStockField<String> INVENTORY_SPECIAL_STOCK_TYPE_ID =
        new InventorySpecialStockField<String>("InventorySpecialStockType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockTypeText</b>
     * </p>
     *
     * @return Inventory Special Stock Type (Description)
     */
    @SerializedName( "InventorySpecialStockTypeText" )
    @JsonProperty( "InventorySpecialStockTypeText" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockTypeText" )
    private String inventorySpecialStockTypeText;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockTypeText</b> field to query operations.
     *
     */
    public final static InventorySpecialStockField<String> INVENTORY_SPECIAL_STOCK_TYPE_TEXT =
        new InventorySpecialStockField<String>("InventorySpecialStockTypeText");

    @Nonnull
    @Override
    public Class<InventorySpecialStock> getType()
    {
        return InventorySpecialStock.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType_ID</b>
     * </p>
     *
     * @param inventorySpecialStockType_ID
     *            Inventory Special Stock Type
     */
    public void setInventorySpecialStockType_ID( @Nullable final String inventorySpecialStockType_ID )
    {
        rememberChangedField("InventorySpecialStockType_ID", this.inventorySpecialStockType_ID);
        this.inventorySpecialStockType_ID = inventorySpecialStockType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockTypeText</b>
     * </p>
     *
     * @param inventorySpecialStockTypeText
     *            Inventory Special Stock Type (Description)
     */
    public void setInventorySpecialStockTypeText( @Nullable final String inventorySpecialStockTypeText )
    {
        rememberChangedField("InventorySpecialStockTypeText", this.inventorySpecialStockTypeText);
        this.inventorySpecialStockTypeText = inventorySpecialStockTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InventorySpecialStockType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InventorySpecialStockType_ID", getInventorySpecialStockType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InventorySpecialStockType_ID", getInventorySpecialStockType_ID());
        values.put("InventorySpecialStockTypeText", getInventorySpecialStockTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InventorySpecialStockType_ID") ) {
                final Object value = values.remove("InventorySpecialStockType_ID");
                if( (value == null) || (!value.equals(getInventorySpecialStockType_ID())) ) {
                    setInventorySpecialStockType_ID(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockTypeText") ) {
                final Object value = values.remove("InventorySpecialStockTypeText");
                if( (value == null) || (!value.equals(getInventorySpecialStockTypeText())) ) {
                    setInventorySpecialStockTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InventorySpecialStockField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InventorySpecialStockField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InventorySpecialStockField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InventorySpecialStockField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
