/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpecialStockSupplierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpecialStockSupplierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inventory Special Stock Supplier (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InventorySpecialStockSupplier extends VdmEntity<InventorySpecialStockSupplier>
{

    /**
     * Selector for all available fields of InventorySpecialStockSupplier.
     *
     */
    public final static InventorySpecialStockSupplierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier_ID</b>
     * </p>
     *
     * @return Inventory Special Stock Supplier
     */
    @Key
    @SerializedName( "InventorySpecialStockSupplier_ID" )
    @JsonProperty( "InventorySpecialStockSupplier_ID" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockSupplier_ID" )
    private String inventorySpecialStockSupplier_ID;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockSupplier_ID</b> field to query operations.
     *
     */
    public final static InventorySpecialStockSupplierField<String> INVENTORY_SPECIAL_STOCK_SUPPLIER_ID =
        new InventorySpecialStockSupplierField<String>("InventorySpecialStockSupplier_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplierText</b>
     * </p>
     *
     * @return Inventory Special Stock Supplier (Description)
     */
    @SerializedName( "InventorySpecialStockSupplierText" )
    @JsonProperty( "InventorySpecialStockSupplierText" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockSupplierText" )
    private String inventorySpecialStockSupplierText;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockSupplierText</b> field to query
     * operations.
     *
     */
    public final static InventorySpecialStockSupplierField<String> INVENTORY_SPECIAL_STOCK_SUPPLIER_TEXT =
        new InventorySpecialStockSupplierField<String>("InventorySpecialStockSupplierText");

    @Nonnull
    @Override
    public Class<InventorySpecialStockSupplier> getType()
    {
        return InventorySpecialStockSupplier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier_ID</b>
     * </p>
     *
     * @param inventorySpecialStockSupplier_ID
     *            Inventory Special Stock Supplier
     */
    public void setInventorySpecialStockSupplier_ID( @Nullable final String inventorySpecialStockSupplier_ID )
    {
        rememberChangedField("InventorySpecialStockSupplier_ID", this.inventorySpecialStockSupplier_ID);
        this.inventorySpecialStockSupplier_ID = inventorySpecialStockSupplier_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplierText</b>
     * </p>
     *
     * @param inventorySpecialStockSupplierText
     *            Inventory Special Stock Supplier (Description)
     */
    public void setInventorySpecialStockSupplierText( @Nullable final String inventorySpecialStockSupplierText )
    {
        rememberChangedField("InventorySpecialStockSupplierText", this.inventorySpecialStockSupplierText);
        this.inventorySpecialStockSupplierText = inventorySpecialStockSupplierText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InventorySpecialStockSupplier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InventorySpecialStockSupplier_ID", getInventorySpecialStockSupplier_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InventorySpecialStockSupplier_ID", getInventorySpecialStockSupplier_ID());
        values.put("InventorySpecialStockSupplierText", getInventorySpecialStockSupplierText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InventorySpecialStockSupplier_ID") ) {
                final Object value = values.remove("InventorySpecialStockSupplier_ID");
                if( (value == null) || (!value.equals(getInventorySpecialStockSupplier_ID())) ) {
                    setInventorySpecialStockSupplier_ID(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockSupplierText") ) {
                final Object value = values.remove("InventorySpecialStockSupplierText");
                if( (value == null) || (!value.equals(getInventorySpecialStockSupplierText())) ) {
                    setInventorySpecialStockSupplierText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InventorySpecialStockSupplierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InventorySpecialStockSupplierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InventorySpecialStockSupplierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InventorySpecialStockSupplierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
