/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpecialStockSupplierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
 * InventorySpecialStockSupplier} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class InventorySpecialStockSupplierByKeyFluentHelper
    extends
    FluentHelperByKey<InventorySpecialStockSupplierByKeyFluentHelper, InventorySpecialStockSupplier, InventorySpecialStockSupplierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
     * InventorySpecialStockSupplier} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param inventorySpecialStockSupplier_ID
     *            Inventory Special Stock Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InventorySpecialStockSupplier}
     * @param servicePath
     *            Service path to be used to fetch a single {@code InventorySpecialStockSupplier}
     */
    public InventorySpecialStockSupplierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inventorySpecialStockSupplier_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("InventorySpecialStockSupplier_ID", inventorySpecialStockSupplier_ID);
    }

    @Override
    @Nonnull
    protected Class<InventorySpecialStockSupplier> getEntityClass()
    {
        return InventorySpecialStockSupplier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
