/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InventorySpecialStockValnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpecialStockValnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inv. Special Stock Val. Type -Deprecated (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InventorySpecialStockValnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InventorySpecialStockValn extends VdmEntity<InventorySpecialStockValn>
{

    /**
     * Selector for all available fields of InventorySpecialStockValn.
     *
     */
    public final static InventorySpecialStockValnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType_ID</b>
     * </p>
     *
     * @return Inv. Special Stock Val. Type -Deprecated
     */
    @Key
    @SerializedName( "InventorySpecialStockValnType_ID" )
    @JsonProperty( "InventorySpecialStockValnType_ID" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockValnType_ID" )
    private String inventorySpecialStockValnType_ID;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockValnType_ID</b> field to query operations.
     *
     */
    public final static InventorySpecialStockValnField<String> INVENTORY_SPECIAL_STOCK_VALN_TYPE_ID =
        new InventorySpecialStockValnField<String>("InventorySpecialStockValnType_ID");

    @Nonnull
    @Override
    public Class<InventorySpecialStockValn> getType()
    {
        return InventorySpecialStockValn.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType_ID</b>
     * </p>
     *
     * @param inventorySpecialStockValnType_ID
     *            Inv. Special Stock Val. Type -Deprecated
     */
    public void setInventorySpecialStockValnType_ID( @Nullable final String inventorySpecialStockValnType_ID )
    {
        rememberChangedField("InventorySpecialStockValnType_ID", this.inventorySpecialStockValnType_ID);
        this.inventorySpecialStockValnType_ID = inventorySpecialStockValnType_ID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InventorySpecialStockValnType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InventorySpecialStockValnType_ID", getInventorySpecialStockValnType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InventorySpecialStockValnType_ID", getInventorySpecialStockValnType_ID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InventorySpecialStockValnType_ID") ) {
                final Object value = values.remove("InventorySpecialStockValnType_ID");
                if( (value == null) || (!value.equals(getInventorySpecialStockValnType_ID())) ) {
                    setInventorySpecialStockValnType_ID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InventorySpecialStockValnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InventorySpecialStockValnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InventorySpecialStockValnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InventorySpecialStockValnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
