/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InventorySpecialStockValnSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
 * InventorySpecialStockValn} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class InventorySpecialStockValnByKeyFluentHelper
    extends
    FluentHelperByKey<InventorySpecialStockValnByKeyFluentHelper, InventorySpecialStockValn, InventorySpecialStockValnSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
     * InventorySpecialStockValn} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code InventorySpecialStockValn}
     * @param inventorySpecialStockValnType_ID
     *            Inv. Special Stock Val. Type -Deprecated
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code InventorySpecialStockValn}
     */
    public InventorySpecialStockValnByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String inventorySpecialStockValnType_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("InventorySpecialStockValnType_ID", inventorySpecialStockValnType_ID);
    }

    @Override
    @Nonnull
    protected Class<InventorySpecialStockValn> getEntityClass()
    {
        return InventorySpecialStockValn.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
