/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.InvtrySpclStockWBSElmntExtIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.InvtrySpclStockWBSElmntExtIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Inventory WBS Element External ID (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InvtrySpclStockWBSElmntExtID extends VdmEntity<InvtrySpclStockWBSElmntExtID>
{

    /**
     * Selector for all available fields of InvtrySpclStockWBSElmntExtID.
     *
     */
    public final static InvtrySpclStockWBSElmntExtIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID_ID</b>
     * </p>
     *
     * @return Inventory WBS Element External ID
     */
    @Key
    @SerializedName( "InvtrySpclStockWBSElmntExtID_ID" )
    @JsonProperty( "InvtrySpclStockWBSElmntExtID_ID" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntExtID_ID" )
    private String invtrySpclStockWBSElmntExtID_ID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntExtID_ID</b> field to query operations.
     *
     */
    public final static InvtrySpclStockWBSElmntExtIDField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_IDID =
        new InvtrySpclStockWBSElmntExtIDField<String>("InvtrySpclStockWBSElmntExtID_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtIDText</b>
     * </p>
     *
     * @return Inventory WBS Element External ID (Description)
     */
    @SerializedName( "InvtrySpclStockWBSElmntExtIDText" )
    @JsonProperty( "InvtrySpclStockWBSElmntExtIDText" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntExtIDText" )
    private String invtrySpclStockWBSElmntExtIDText;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntExtIDText</b> field to query operations.
     *
     */
    public final static InvtrySpclStockWBSElmntExtIDField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID_TEXT =
        new InvtrySpclStockWBSElmntExtIDField<String>("InvtrySpclStockWBSElmntExtIDText");

    @Nonnull
    @Override
    public Class<InvtrySpclStockWBSElmntExtID> getType()
    {
        return InvtrySpclStockWBSElmntExtID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID_ID</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntExtID_ID
     *            Inventory WBS Element External ID
     */
    public void setInvtrySpclStockWBSElmntExtID_ID( @Nullable final String invtrySpclStockWBSElmntExtID_ID )
    {
        rememberChangedField("InvtrySpclStockWBSElmntExtID_ID", this.invtrySpclStockWBSElmntExtID_ID);
        this.invtrySpclStockWBSElmntExtID_ID = invtrySpclStockWBSElmntExtID_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtIDText</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntExtIDText
     *            Inventory WBS Element External ID (Description)
     */
    public void setInvtrySpclStockWBSElmntExtIDText( @Nullable final String invtrySpclStockWBSElmntExtIDText )
    {
        rememberChangedField("InvtrySpclStockWBSElmntExtIDText", this.invtrySpclStockWBSElmntExtIDText);
        this.invtrySpclStockWBSElmntExtIDText = invtrySpclStockWBSElmntExtIDText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "InvtrySpclStockWBSElmntExtID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InvtrySpclStockWBSElmntExtID_ID", getInvtrySpclStockWBSElmntExtID_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InvtrySpclStockWBSElmntExtID_ID", getInvtrySpclStockWBSElmntExtID_ID());
        values.put("InvtrySpclStockWBSElmntExtIDText", getInvtrySpclStockWBSElmntExtIDText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InvtrySpclStockWBSElmntExtID_ID") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntExtID_ID");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntExtID_ID())) ) {
                    setInvtrySpclStockWBSElmntExtID_ID(((String) value));
                }
            }
            if( values.containsKey("InvtrySpclStockWBSElmntExtIDText") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntExtIDText");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntExtIDText())) ) {
                    setInvtrySpclStockWBSElmntExtIDText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> InvtrySpclStockWBSElmntExtIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new InvtrySpclStockWBSElmntExtIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InvtrySpclStockWBSElmntExtIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InvtrySpclStockWBSElmntExtIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
